/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.SubmitHttpXCommand;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class SubmitMRXCommand
extends SubmitHttpXCommand {
    private static final Set<String> SKIPPED_CONFS = new HashSet<String>();
    private static final Map<String, String> DEPRECATE_MAP = new HashMap<String, String>();

    public SubmitMRXCommand(Configuration conf) {
        super("submitMR", "submitMR", conf);
    }

    private Element generateConfigurationSection(Configuration conf, Namespace ns) {
        Element configuration = null;
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (MANDATORY_OOZIE_CONFS.contains(name) || OPTIONAL_OOZIE_CONFS.contains(name) || SKIPPED_CONFS.contains(name) || DEPRECATE_MAP.containsValue(name)) continue;
            if (configuration == null) {
                configuration = new Element("configuration", ns);
            }
            String value = (String)entry.getValue();
            Element property = new Element("property", ns);
            Element nameElement = new Element("name", ns);
            nameElement.addContent(name != null ? name : "");
            property.addContent((Content)nameElement);
            Element valueElement = new Element("value", ns);
            valueElement.addContent(value != null ? value : "");
            property.addContent((Content)valueElement);
            configuration.addContent((Content)property);
        }
        return configuration;
    }

    private Element generateMRSection(Configuration conf, Namespace ns) {
        Element mapreduce = new Element("map-reduce", ns);
        Element jt = new Element("job-tracker", ns);
        String newJTVal = conf.get(DEPRECATE_MAP.get("mapred.job.tracker"));
        jt.addContent(newJTVal != null ? newJTVal : conf.get("mapred.job.tracker"));
        mapreduce.addContent((Content)jt);
        Element nn = new Element("name-node", ns);
        String newNNVal = conf.get(DEPRECATE_MAP.get("fs.default.name"));
        nn.addContent(newNNVal != null ? newNNVal : conf.get("fs.default.name"));
        mapreduce.addContent((Content)nn);
        if (conf.size() > MANDATORY_OOZIE_CONFS.size()) {
            Element configuration = this.generateConfigurationSection(conf, ns);
            if (configuration != null) {
                mapreduce.addContent((Content)configuration);
            }
            SubmitMRXCommand.addFileSection(mapreduce, conf, ns);
            SubmitMRXCommand.addArchiveSection(mapreduce, conf, ns);
        }
        return mapreduce;
    }

    @Override
    protected String getWorkflowXml(Configuration conf) {
        for (String key : MANDATORY_OOZIE_CONFS) {
            String value = conf.get(key);
            if (value != null) continue;
            if (DEPRECATE_MAP.containsKey(key)) {
                if (conf.get(DEPRECATE_MAP.get(key)) != null) continue;
                throw new RuntimeException(key + " or " + DEPRECATE_MAP.get(key) + " is not specified");
            }
            throw new RuntimeException(key + " is not specified");
        }
        Namespace ns = Namespace.getNamespace((String)"uri:oozie:workflow:0.2");
        Element root = new Element("workflow-app", ns);
        root.setAttribute("name", "oozie-mapreduce");
        Element start = new Element("start", ns);
        start.setAttribute("to", "hadoop1");
        root.addContent((Content)start);
        Element action = new Element("action", ns);
        action.setAttribute("name", "hadoop1");
        Element mapreduce = this.generateMRSection(conf, ns);
        action.addContent((Content)mapreduce);
        Element ok = new Element("ok", ns);
        ok.setAttribute("to", "end");
        action.addContent((Content)ok);
        Element error = new Element("error", ns);
        error.setAttribute("to", "fail");
        action.addContent((Content)error);
        root.addContent((Content)action);
        Element kill = new Element("kill", ns);
        kill.setAttribute("name", "fail");
        Element message = new Element("message", ns);
        message.addContent("Map/Reduce failed, error message[${wf:errorMessage(wf:lastErrorNode())}]");
        kill.addContent((Content)message);
        root.addContent((Content)kill);
        Element end = new Element("end", ns);
        end.setAttribute("name", "end");
        root.addContent((Content)end);
        return XmlUtils.prettyPrint(root).toString();
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() {
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }

    static {
        SKIPPED_CONFS.add("user.name");
        SKIPPED_CONFS.add("mapred.job.tracker");
        SKIPPED_CONFS.add("fs.default.name");
        SKIPPED_CONFS.add("fs.defaultFS");
        DEPRECATE_MAP.put("fs.default.name", "fs.defaultFS");
        DEPRECATE_MAP.put("mapred.job.tracker", "mapreduce.jobtracker.address");
        DEPRECATE_MAP.put("user.name", "mapreduce.job.user.name");
    }
}

