/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa.sla;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.sla.SLASummaryBean;

public class SLASummaryGetRecordsOnRestartJPAExecutor
implements JPAExecutor<List<SLASummaryBean>> {
    private int days;

    public SLASummaryGetRecordsOnRestartJPAExecutor(int days) {
        this.days = days;
    }

    @Override
    public String getName() {
        return "SLASummaryGetRecordsOnRestartJPAExecutor";
    }

    @Override
    public List<SLASummaryBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_SLA_SUMMARY_RECORDS_RESTART");
            Timestamp ts = new Timestamp(System.currentTimeMillis() - (long)(this.days * 24 * 60 * 60 * 1000));
            q.setParameter("lastModifiedTime", (Object)ts);
            List ssBean = q.getResultList();
            return ssBean;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

