/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.oozie.util.XLogStreamer;

public class TimestampedMessageParser {
    protected BufferedReader reader;
    private String nextLine = null;
    private String lastTimestamp = null;
    private XLogStreamer.Filter filter;
    private boolean empty = false;
    private String lastMessage = null;
    private boolean patternMatched = false;

    public TimestampedMessageParser(BufferedReader reader, XLogStreamer.Filter filter) {
        this.reader = reader;
        this.filter = filter;
        if (filter == null) {
            filter = new XLogStreamer.Filter();
        }
        filter.constructPattern();
    }

    public boolean increment() throws IOException {
        if (this.empty) {
            return false;
        }
        StringBuilder message = new StringBuilder();
        if (this.nextLine == null) {
            this.nextLine = this.parseNextLine();
            if (this.nextLine == null) {
                this.empty = true;
                return false;
            }
        }
        this.lastTimestamp = this.parseTimestamp(this.nextLine);
        String nextTimestamp = null;
        while (nextTimestamp == null) {
            message.append(this.nextLine).append("\n");
            this.nextLine = this.parseNextLine();
            if (this.nextLine != null) {
                nextTimestamp = this.parseTimestamp(this.nextLine);
                continue;
            }
            this.empty = true;
            nextTimestamp = "";
        }
        this.lastMessage = message.toString();
        return true;
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void closeReader() throws IOException {
        this.reader.close();
    }

    protected String parseNextLine() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            ArrayList<String> logParts = this.filter.splitLogMessage(line);
            if (logParts != null) {
                this.patternMatched = this.filter.matches(logParts);
            }
            if (!this.patternMatched) {
                line = this.parseNextLine();
            }
        }
        return line;
    }

    private String parseTimestamp(String line) {
        String timestamp = null;
        ArrayList<String> logParts = this.filter.splitLogMessage(line);
        if (logParts != null) {
            timestamp = logParts.get(0);
        }
        return timestamp;
    }

    public void processRemaining(Writer writer) throws IOException {
        while (this.increment()) {
            writer.write(this.getLastMessage());
        }
    }
}

