/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.pmd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.IPmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.background.BackgroundCancellableProcessHelper;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.ui.datasources.pmd.Messages;
import org.pentaho.reporting.ui.datasources.pmd.PmdDataSourceModule;
import org.pentaho.reporting.ui.datasources.pmd.PmdPreviewWorker;
import org.pentaho.reporting.ui.datasources.pmd.util.CreateMqlEditorTask;
import org.pentaho.reporting.ui.datasources.pmd.util.DataSetQuery;
import org.pentaho.reporting.ui.datasources.pmd.util.LimitRowsCheckBoxActionListener;
import org.pentaho.reporting.ui.datasources.pmd.util.LoadRepositoryRunnable;
import org.pentaho.reporting.ui.datasources.pmd.util.QueryLanguageListCellRenderer;
import org.pentaho.reporting.ui.datasources.pmd.util.QueryNameListCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PmdDataSourceEditor
extends CommonDialog {
    private static final Log logger = LogFactory.getLog(PmdDataSourceEditor.class);
    private JList queryNameList;
    private JButton queryRemoveButton;
    private JButton queryDesignerButton;
    private JButton queryAddButton;
    private JTextField domainIdTextField;
    private JTextField queryNameTextField;
    private JTextField filenameField;
    private RSyntaxTextArea queryTextArea;
    private Map<String, DataSetQuery> queries;
    private boolean inQueryNameUpdate;
    private boolean inModifyingQueryNameList;
    private DesignTimeContext context;
    private JSpinner maxPreviewRowsSpinner;
    private Action previewAction;
    private RSyntaxTextArea globalScriptTextArea;
    private SmartComboBox globalLanguageField;
    private RSyntaxTextArea queryScriptTextArea;
    private SmartComboBox queryLanguageField;
    private QueryLanguageListCellRenderer queryLanguageListCellRenderer;
    private GlobalTemplateAction globalTemplateAction;
    private QueryTemplateAction queryTemplateAction;

    public PmdDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public PmdDataSourceEditor(DesignTimeContext context, Dialog owner) {
        super(owner);
        this.init(context);
    }

    public PmdDataSourceEditor(DesignTimeContext context, Frame owner) {
        super(owner);
        this.init(context);
    }

    private void init(DesignTimeContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.setModal(true);
        this.setTitle(Messages.getString("PmdDataSourceEditor.Title", new Object[0]));
        this.maxPreviewRowsSpinner = new JSpinner(new SpinnerNumberModel(10000, 1, Integer.MAX_VALUE, 1));
        this.previewAction = new PreviewAction();
        this.globalTemplateAction = new GlobalTemplateAction();
        this.queryTemplateAction = new QueryTemplateAction();
        this.filenameField = new JTextField(null, 0);
        this.filenameField.setColumns(30);
        this.filenameField.getDocument().addDocumentListener((DocumentListener)((Object)new FilenameDocumentListener()));
        this.queryNameList = new JList();
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QueryNameListSelectionListener());
        this.queryNameList.setCellRenderer(new QueryNameListCellRenderer());
        this.queryAddButton = new BorderlessButton((Action)new AddQueryAction());
        this.queryRemoveButton = new BorderlessButton((Action)new RemoveQueryAction());
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)new QueryNameTextFieldDocumentListener()));
        this.domainIdTextField = new JTextField(null, 0);
        this.domainIdTextField.setColumns(35);
        this.domainIdTextField.getDocument().addDocumentListener((DocumentListener)((Object)new DomainTextFieldDocumentListener()));
        this.queryTextArea = new RSyntaxTextArea();
        this.queryTextArea.setSyntaxEditingStyle("text/xml");
        this.queryTextArea.setWrapStyleWord(true);
        this.queryTextArea.setLineWrap(true);
        this.queryTextArea.setRows(5);
        this.queryTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryDocumentListener()));
        this.queryDesignerButton = new JButton(new QueryDesignerAction());
        this.queryDesignerButton.setEnabled(false);
        this.queryDesignerButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.globalScriptTextArea = new RSyntaxTextArea();
        this.globalScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.globalLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(this.getScriptEngineLanguages()));
        this.globalLanguageField.setRenderer((ListCellRenderer)new QueryLanguageListCellRenderer());
        this.globalLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        this.queryScriptTextArea = new RSyntaxTextArea();
        this.queryScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.queryScriptTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryScriptDocumentListener()));
        this.queryLanguageListCellRenderer = new QueryLanguageListCellRenderer();
        this.queryLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(this.getScriptEngineLanguages()));
        this.queryLanguageField.setRenderer((ListCellRenderer)this.queryLanguageListCellRenderer);
        this.queryLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        super.init();
    }

    protected String getDialogId() {
        return "PmdDataSourceEditor";
    }

    private ScriptEngineFactory[] getScriptEngineLanguages() {
        LinkedHashSet<ScriptEngineFactory> langSet = new LinkedHashSet<ScriptEngineFactory>();
        langSet.add(null);
        List<ScriptEngineFactory> engineFactories = new ScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory engineFactory : engineFactories) {
            langSet.add(engineFactory);
        }
        return langSet.toArray(new ScriptEngineFactory[langSet.size()]);
    }

    protected Component createContentPane() {
        JPanel queryTextAreaHeaderPanel = new JPanel(new BorderLayout());
        queryTextAreaHeaderPanel.add((Component)new JLabel(Messages.getString("PmdDataSourceEditor.QueryLabel", new Object[0])), "West");
        queryTextAreaHeaderPanel.add((Component)this.queryDesignerButton, "East");
        JPanel queryConfigurationPanel = new JPanel();
        queryConfigurationPanel.setLayout(new BorderLayout());
        queryConfigurationPanel.add((Component)queryTextAreaHeaderPanel, "North");
        queryConfigurationPanel.add((Component)new RTextScrollPane(700, 500, (RTextArea)this.queryTextArea, true), "Center");
        JTabbedPane queryScriptTabPane = new JTabbedPane();
        queryScriptTabPane.addTab(Messages.getString("PmdDataSourceEditor.StaticQuery", new Object[0]), queryConfigurationPanel);
        queryScriptTabPane.addTab(Messages.getString("PmdDataSourceEditor.QueryScripting", new Object[0]), this.createQueryScriptTab());
        JPanel queryAreaPanel = new JPanel();
        queryAreaPanel.setLayout(new BorderLayout());
        queryAreaPanel.add((Component)this.createGlobalPropertiesPanel(), "North");
        queryAreaPanel.add((Component)queryScriptTabPane, "Center");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("PmdDataSourceEditor.DataSource", new Object[0]), queryAreaPanel);
        tabbedPane.addTab(Messages.getString("PmdDataSourceEditor.GlobalScripting", new Object[0]), this.createGlobalScriptTab());
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)tabbedPane, "Center");
        contentPanel.add((Component)this.createPreviewButtonsPanel(), "South");
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return contentPanel;
    }

    private JPanel createQueryScriptTab() {
        JPanel queryHeader2 = new JPanel(new BorderLayout());
        queryHeader2.add((Component)new JLabel(Messages.getString("PmdDataSourceEditor.QueryScript", new Object[0])), "Center");
        queryHeader2.add((Component)new JButton(this.queryTemplateAction), "East");
        JPanel queryScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        queryScriptHeader.add(new JLabel(Messages.getString("PmdDataSourceEditor.QueryScriptLanguage", new Object[0])));
        queryScriptHeader.add((Component)this.queryLanguageField);
        queryScriptHeader.add(queryHeader2);
        JPanel queryScriptContentHolder = new JPanel(new BorderLayout());
        queryScriptContentHolder.add((Component)queryScriptHeader, "North");
        queryScriptContentHolder.add((Component)new RTextScrollPane(700, 300, (RTextArea)this.queryScriptTextArea, true), "Center");
        return queryScriptContentHolder;
    }

    private JPanel createGlobalScriptTab() {
        JPanel globalHeader2 = new JPanel(new BorderLayout());
        globalHeader2.add((Component)new JLabel(Messages.getString("PmdDataSourceEditor.GlobalScript", new Object[0])), "Center");
        globalHeader2.add((Component)new JButton(this.globalTemplateAction), "East");
        JPanel globalScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        globalScriptHeader.add(new JLabel(Messages.getString("PmdDataSourceEditor.GlobalScriptLanguage", new Object[0])));
        globalScriptHeader.add((Component)this.globalLanguageField);
        globalScriptHeader.add(globalHeader2);
        JPanel globalScriptContentHolder = new JPanel(new BorderLayout());
        globalScriptContentHolder.add((Component)globalScriptHeader, "North");
        globalScriptContentHolder.add((Component)new RTextScrollPane(700, 600, (RTextArea)this.globalScriptTextArea, true), "Center");
        return globalScriptContentHolder;
    }

    private JPanel createGlobalPropertiesPanel() {
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(this.filenameField);
        filePanel.add(new JButton(new BrowseAction()));
        JPanel queryListButtonsPanel = new JPanel(new FlowLayout(2));
        queryListButtonsPanel.add(this.queryAddButton);
        queryListButtonsPanel.add(this.queryRemoveButton);
        JPanel queryListButtonsPanelWrapper = new JPanel(new BorderLayout());
        queryListButtonsPanelWrapper.add((Component)new JLabel(Messages.getString("PmdDataSourceEditor.AvailableQueries", new Object[0])), "West");
        queryListButtonsPanelWrapper.add((Component)queryListButtonsPanel, "East");
        JPanel dataSourceConfigurationPanel = new JPanel();
        dataSourceConfigurationPanel.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        dataSourceConfigurationPanel.add(new JLabel(Messages.getString("PmdDataSourceEditor.XmiFileLabel", new Object[0])));
        dataSourceConfigurationPanel.add(filePanel);
        dataSourceConfigurationPanel.add(new JLabel(Messages.getString("PmdDataSourceEditor.DomainId", new Object[0])));
        dataSourceConfigurationPanel.add(this.domainIdTextField);
        dataSourceConfigurationPanel.add(queryListButtonsPanelWrapper);
        dataSourceConfigurationPanel.add(new JScrollPane(this.queryNameList));
        dataSourceConfigurationPanel.add(new JLabel(Messages.getString("PmdDataSourceEditor.QueryName", new Object[0])));
        dataSourceConfigurationPanel.add(this.queryNameTextField);
        return dataSourceConfigurationPanel;
    }

    private JPanel createPreviewButtonsPanel() {
        JPanel previewButtonsPanel = new JPanel(new FlowLayout(2));
        previewButtonsPanel.add(new JCheckBox(new LimitRowsCheckBoxActionListener(this.maxPreviewRowsSpinner)));
        previewButtonsPanel.add(this.maxPreviewRowsSpinner);
        previewButtonsPanel.add(new JButton(this.previewAction));
        return previewButtonsPanel;
    }

    public PmdDataFactory performConfiguration(PmdDataFactory dataFactory, String selectedQuery) {
        this.queries = new TreeMap<String, DataSetQuery>();
        if (dataFactory != null) {
            this.filenameField.setText(dataFactory.getXmiFile());
            this.domainIdTextField.setText(dataFactory.getDomainId());
            this.setGlobalScriptingLanguage(dataFactory.getGlobalScriptLanguage());
            this.globalScriptTextArea.setText(dataFactory.getGlobalScript());
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                String query = dataFactory.getQuery(queryName);
                String scriptLanguage = dataFactory.getScriptingLanguage(queryName);
                String script = dataFactory.getScript(queryName);
                this.queries.put(queryName, new DataSetQuery(queryName, query, scriptLanguage, script));
            }
        }
        this.updateComponents();
        this.updateQueryList();
        this.setSelectedQuery(selectedQuery);
        if (!this.performEdit()) {
            return null;
        }
        return this.createDataFactory();
    }

    private void setGlobalScriptingLanguage(String lang) {
        this.setScriptingLanguage(lang, (JComboBox)this.globalLanguageField);
    }

    protected void setScriptingLanguage(String lang, JComboBox languageField) {
        if (lang == null) {
            languageField.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = languageField.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScriptEngineFactory elementAt = (ScriptEngineFactory)model.getElementAt(i);
            if (elementAt == null || !elementAt.getNames().contains(lang)) continue;
            languageField.setSelectedItem(elementAt);
            return;
        }
    }

    private String getGlobalScriptingLanguage() {
        ScriptEngineFactory selectedValue = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        if (selectedValue == null) {
            return null;
        }
        return selectedValue.getLanguageName();
    }

    private PmdDataFactory createDataFactory() {
        PmdDataFactory returnDataFactory = new PmdDataFactory();
        returnDataFactory.setXmiFile(this.filenameField.getText());
        returnDataFactory.setDomainId(this.domainIdTextField.getText());
        returnDataFactory.setConnectionProvider((IPmdConnectionProvider)new PmdConnectionProvider());
        returnDataFactory.setGlobalScriptLanguage(this.getGlobalScriptingLanguage());
        if (!StringUtils.isEmpty((String)this.globalScriptTextArea.getText())) {
            returnDataFactory.setGlobalScript(this.globalScriptTextArea.getText());
        }
        for (DataSetQuery query : this.queries.values()) {
            returnDataFactory.setQuery(query.getQueryName(), query.getQuery(), query.getScriptLanguage(), query.getScript());
        }
        return returnDataFactory;
    }

    protected void updateQueryList() {
        if (!this.queries.isEmpty()) {
            this.queryNameList.setListData(this.queries.values().toArray(new DataSetQuery[this.queries.size()]));
        } else {
            this.queryNameList.setListData(new Object[0]);
        }
    }

    private void setSelectedQuery(String query) {
        ListModel listModel = this.queryNameList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            DataSetQuery dataSet = (DataSetQuery)listModel.getElementAt(i);
            if (!dataSet.getQueryName().equals(query)) continue;
            this.queryNameList.setSelectedValue(dataSet, true);
            break;
        }
    }

    protected void updateComponents() {
        boolean querySelected = this.queryNameList.getSelectedIndex() != -1;
        boolean hasQueries = this.queryNameList.getModel().getSize() > 0;
        boolean isFileSelected = !StringUtils.isEmpty((String)this.filenameField.getText(), (boolean)true);
        boolean hasDomain = !StringUtils.isEmpty((String)this.domainIdTextField.getText(), (boolean)true);
        this.queryLanguageListCellRenderer.setDefaultValue((ScriptEngineFactory)this.globalLanguageField.getSelectedItem());
        this.domainIdTextField.setEnabled(isFileSelected);
        this.previewAction.setEnabled(isFileSelected && querySelected);
        this.queryNameTextField.setEnabled(querySelected);
        this.queryTextArea.setEnabled(querySelected);
        this.queryRemoveButton.setEnabled(querySelected);
        this.queryDesignerButton.setEnabled(hasDomain && querySelected && isFileSelected);
        this.queryAddButton.setEnabled(true);
        this.globalScriptTextArea.setSyntaxEditingStyle(this.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)this.globalLanguageField.getSelectedItem()));
        ScriptEngineFactory queryScriptLanguage = (ScriptEngineFactory)this.queryLanguageField.getSelectedItem();
        if (queryScriptLanguage == null) {
            this.queryScriptTextArea.setSyntaxEditingStyle(this.globalScriptTextArea.getSyntaxEditingStyle());
        } else {
            this.queryScriptTextArea.setSyntaxEditingStyle(this.mapLanguageToSyntaxHighlighting(queryScriptLanguage));
        }
        this.getConfirmAction().setEnabled(hasQueries && isFileSelected);
        this.queryScriptTextArea.setEnabled(querySelected);
        this.queryLanguageField.setEnabled(querySelected);
        this.queryTemplateAction.update();
        if (!querySelected) {
            this.queryTemplateAction.setEnabled(false);
        }
        this.globalTemplateAction.update();
    }

    private String mapLanguageToSyntaxHighlighting(ScriptEngineFactory script) {
        if (script == null) {
            return "text/plain";
        }
        String language = script.getLanguageName();
        if ("ECMAScript".equalsIgnoreCase(language) || "js".equalsIgnoreCase(language) || "rhino".equalsIgnoreCase(language) || "javascript".equalsIgnoreCase(language)) {
            return "text/javascript";
        }
        if ("groovy".equalsIgnoreCase(language)) {
            return "text/groovy";
        }
        return "text/plain";
    }

    protected void updateQueries() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            DataSetQuery[] objects = this.queries.values().toArray(new DataSetQuery[this.queries.size()]);
            for (int i = 0; i < objects.length; ++i) {
                DataSetQuery object = objects[i];
                String text = object.getQuery();
                if (StringUtils.isEmpty((String)text, (boolean)true)) continue;
                try {
                    Document doc = documentBuilder.parse(new InputSource(new StringReader(text)));
                    NodeList list = doc.getDocumentElement().getElementsByTagName("domain_id");
                    if (list.getLength() == 0) continue;
                    list.item(0).setTextContent(this.domainIdTextField.getText());
                    TransformerFactory tfactory = TransformerFactory.newInstance();
                    StringWriter stringWriter = new StringWriter();
                    StreamResult result = new StreamResult();
                    result.setWriter(stringWriter);
                    tfactory.newTransformer().transform(new DOMSource(doc), result);
                    object.setQuery(stringWriter.getBuffer().toString());
                    continue;
                }
                catch (Exception e) {
                    this.context.error(e);
                }
            }
        }
        catch (Exception e) {
            this.context.error(e);
        }
        Object o = this.queryNameList.getSelectedValue();
        if (o != null) {
            DataSetQuery q = (DataSetQuery)o;
            this.queryTextArea.setText(q.getQuery());
        }
    }

    private class QueryTemplateAction
    extends AbstractAction {
        private URL resource;

        private QueryTemplateAction() {
            this.putValue("Name", Messages.getString("PmdDataSourceEditor.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)PmdDataSourceEditor.this.queryScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)PmdDataSourceEditor.this), Messages.getString("PmdDataSourceEditor.OverwriteScript", new Object[0]), Messages.getString("PmdDataSourceEditor.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try {
                InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");
                try {
                    StringWriter w = new StringWriter();
                    IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                    PmdDataSourceEditor.this.queryScriptTextArea.insert(w.toString(), 0);
                }
                finally {
                    r.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = PmdDataSourceEditor.this.queryScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = PmdDataSourceEditor.class.getResource("resources/query-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class GlobalTemplateAction
    extends AbstractAction {
        private URL resource;

        private GlobalTemplateAction() {
            this.putValue("Name", Messages.getString("PmdDataSourceEditor.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)PmdDataSourceEditor.this.globalScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)PmdDataSourceEditor.this), Messages.getString("PmdDataSourceEditor.OverwriteScript", new Object[0]), Messages.getString("PmdDataSourceEditor.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try {
                InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");
                try {
                    StringWriter w = new StringWriter();
                    IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                    PmdDataSourceEditor.this.globalScriptTextArea.setText(w.toString());
                }
                finally {
                    r.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = PmdDataSourceEditor.this.globalScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = PmdDataSourceEditor.class.getResource("resources/global-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class UpdateScriptLanguageHandler
    implements ActionListener,
    ListSelectionListener {
        private UpdateScriptLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = (DataSetQuery)PmdDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                ScriptEngineFactory selectedItem = (ScriptEngineFactory)PmdDataSourceEditor.this.queryLanguageField.getSelectedItem();
                if (selectedItem != null) {
                    query.setScriptLanguage(selectedItem.getLanguageName());
                } else {
                    query.setScriptLanguage(null);
                }
            }
            PmdDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PmdDataSourceEditor.this.updateComponents();
        }
    }

    private class PreviewAction
    extends AbstractAction {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("PmdDataSourceEditor.Preview.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)PmdDataSourceEditor.this));
                String query = PmdDataSourceEditor.this.queryNameTextField.getText();
                Integer theMaxRows = 0;
                if (PmdDataSourceEditor.this.maxPreviewRowsSpinner.isEnabled()) {
                    theMaxRows = (Integer)PmdDataSourceEditor.this.maxPreviewRowsSpinner.getValue();
                }
                PmdDataFactory dataFactory = PmdDataSourceEditor.this.createDataFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)PmdDataSourceEditor.this.context);
                PmdPreviewWorker worker = new PmdPreviewWorker(dataFactory, query, 0, theMaxRows);
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)PmdDataSourceEditor.this), (String)Messages.getString("PmdDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("PmdDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)factoryException);
                }
            }
            catch (Exception e) {
                PmdDataSourceEditor.this.context.error(e);
                ExceptionDialog.showExceptionDialog((Component)((Object)PmdDataSourceEditor.this), (String)Messages.getString("PmdDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("PmdDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)e);
            }
        }
    }

    private class FilenameDocumentListener
    extends DocumentChangeHandler {
        private FilenameDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            PmdDataSourceEditor.this.updateComponents();
        }
    }

    private class DomainTextFieldDocumentListener
    extends DocumentChangeHandler
    implements Runnable {
        private DomainTextFieldDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            PmdDataSourceEditor.this.updateComponents();
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            PmdDataSourceEditor.this.updateQueries();
        }
    }

    private class QueryNameTextFieldDocumentListener
    extends DocumentChangeHandler {
        private QueryNameTextFieldDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            if (PmdDataSourceEditor.this.inModifyingQueryNameList) {
                return;
            }
            String queryName = PmdDataSourceEditor.this.queryNameTextField.getText();
            DataSetQuery currentQuery = (DataSetQuery)PmdDataSourceEditor.this.queryNameList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            if (queryName.equals(currentQuery.getQueryName())) {
                return;
            }
            if (PmdDataSourceEditor.this.queries.containsKey(queryName)) {
                return;
            }
            PmdDataSourceEditor.this.inQueryNameUpdate = true;
            PmdDataSourceEditor.this.queries.remove(currentQuery.getQueryName());
            currentQuery.setQueryName(queryName);
            PmdDataSourceEditor.this.queries.put(currentQuery.getQueryName(), currentQuery);
            PmdDataSourceEditor.this.updateQueryList();
            PmdDataSourceEditor.this.queryNameList.setSelectedValue(currentQuery, true);
            PmdDataSourceEditor.this.inQueryNameUpdate = false;
        }
    }

    private class QueryScriptDocumentListener
    extends DocumentChangeHandler {
        private QueryScriptDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            DataSetQuery query = (DataSetQuery)PmdDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                query.setScript(PmdDataSourceEditor.this.queryScriptTextArea.getText());
            }
        }
    }

    private class QueryDocumentListener
    extends DocumentChangeHandler {
        private QueryDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            DataSetQuery query = (DataSetQuery)PmdDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                query.setQuery(PmdDataSourceEditor.this.queryTextArea.getText());
            }
        }
    }

    private class RemoveQueryAction
    extends AbstractAction {
        public RemoveQueryAction() {
            URL resource = PmdDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/pmd/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("PmdDataSourceEditor.RemoveQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("PmdDataSourceEditor.RemoveQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = (DataSetQuery)PmdDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                PmdDataSourceEditor.this.queries.remove(query.getQueryName());
            }
            PmdDataSourceEditor.this.inModifyingQueryNameList = true;
            PmdDataSourceEditor.this.updateQueryList();
            PmdDataSourceEditor.this.queryNameList.clearSelection();
            PmdDataSourceEditor.this.inModifyingQueryNameList = false;
            PmdDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryDesignerAction
    extends AbstractAction {
        public QueryDesignerAction() {
            URL resource = PmdDataSourceModule.class.getResource("/org/pentaho/reporting/ui/datasources/pmd/resources/Edit.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("PmdDataSourceEditor.EditQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("PmdDataSourceEditor.EditQuery.Description", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thread t = new Thread(new PrepareAndInvokeMqlEditorTask());
            t.start();
        }
    }

    private class PrepareAndInvokeMqlEditorTask
    implements Runnable {
        private PrepareAndInvokeMqlEditorTask() {
        }

        @Override
        public void run() {
            DataSetQuery query = (DataSetQuery)PmdDataSourceEditor.this.queries.get(PmdDataSourceEditor.this.queryNameTextField.getText());
            if (query == null) {
                return;
            }
            try {
                LoadRepositoryRunnable loadRepositoryRunnable = new LoadRepositoryRunnable(PmdDataSourceEditor.this.context, PmdDataSourceEditor.this.domainIdTextField.getText(), PmdDataSourceEditor.this.filenameField.getText());
                Thread loadRepositoryThread = new Thread(loadRepositoryRunnable);
                BackgroundCancellableProcessHelper.executeProcessWithCancelDialog((Thread)loadRepositoryThread, null, (Component)((Object)PmdDataSourceEditor.this), (String)Messages.getString("PmdDataSourceEditor.PreviewTask", new Object[0]));
                IMetadataDomainRepository repository = loadRepositoryRunnable.getRepository();
                if (repository == null) {
                    return;
                }
                SwingUtilities.invokeLater(new CreateMqlEditorTask(repository, PmdDataSourceEditor.this.context, query, (JTextComponent)PmdDataSourceEditor.this.queryTextArea));
            }
            catch (Exception exc) {
                PmdDataSourceEditor.this.context.error(exc);
            }
        }
    }

    private class AddQueryAction
    extends AbstractAction {
        public AddQueryAction() {
            URL resource = PmdDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/pmd/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("PmdDataSourceEditor.AddQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("PmdDataSourceEditor.AddQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = "PmdDataSourceEditor.Query";
            for (int i = 1; i < 1000; ++i) {
                String newQueryName = Messages.getString("PmdDataSourceEditor.Query", new Object[0]) + " " + i;
                if (PmdDataSourceEditor.this.queries.containsKey(newQueryName)) continue;
                queryName = newQueryName;
                break;
            }
            DataSetQuery newQuery = new DataSetQuery(queryName, "", null, null);
            PmdDataSourceEditor.this.queries.put(newQuery.getQueryName(), newQuery);
            PmdDataSourceEditor.this.inModifyingQueryNameList = true;
            PmdDataSourceEditor.this.updateQueryList();
            PmdDataSourceEditor.this.queryNameList.setSelectedValue(newQuery, true);
            PmdDataSourceEditor.this.inModifyingQueryNameList = false;
            PmdDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryNameListSelectionListener
    implements ListSelectionListener {
        private QueryNameListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PmdDataSourceEditor.this.inQueryNameUpdate) {
                return;
            }
            DataSetQuery query = (DataSetQuery)PmdDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                PmdDataSourceEditor.this.queryNameTextField.setText(query.getQueryName());
                PmdDataSourceEditor.this.queryTextArea.setText(query.getQuery());
                PmdDataSourceEditor.this.queryScriptTextArea.setText(query.getScript());
                PmdDataSourceEditor.this.setScriptingLanguage(query.getScriptLanguage(), (JComboBox)PmdDataSourceEditor.this.queryLanguageField);
                PmdDataSourceEditor.this.updateComponents();
            } else {
                PmdDataSourceEditor.this.queryNameTextField.setText("");
                PmdDataSourceEditor.this.queryTextArea.setText("");
                PmdDataSourceEditor.this.queryScriptTextArea.setText("");
                PmdDataSourceEditor.this.setScriptingLanguage(null, (JComboBox)PmdDataSourceEditor.this.queryLanguageField);
                PmdDataSourceEditor.this.updateComponents();
            }
        }
    }

    private class BrowseAction
    extends AbstractAction {
        protected BrowseAction() {
            this.putValue("Name", Messages.getString("PmdDataSourceEditor.Browse.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)PmdDataSourceEditor.this.context.getReport());
            File initiallySelectedFile = !StringUtils.isEmpty((String)PmdDataSourceEditor.this.filenameField.getText(), (boolean)true) ? (reportContextFile != null ? new File(reportContextFile.getParentFile(), PmdDataSourceEditor.this.filenameField.getText()) : new File(PmdDataSourceEditor.this.filenameField.getText())) : null;
            FileFilter[] fileFilters = new FileFilter[]{new FilesystemFilter(new String[]{".xmi"}, Messages.getString("PmdDataSourceEditor.XmiFileName", new Object[0]) + " (*.xmi)", true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("xmifile");
            fileChooser.setSelectedFile(initiallySelectedFile);
            fileChooser.setFilters(fileFilters);
            if (!fileChooser.showDialog((Component)((Object)PmdDataSourceEditor.this), 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            PmdDataSourceEditor.this.filenameField.setText(path);
        }
    }
}

