/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.olap4j;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.ui.datasources.olap4j.Messages;

public class Olap4JSecurityDialog
extends CommonDialog {
    private JComboBox roleFieldBox;
    private JComboBox jdbcUserFieldBox;
    private JComboBox jdbcPasswordFieldBox;

    public Olap4JSecurityDialog(DesignTimeContext context) throws HeadlessException {
        this.init(context);
    }

    public Olap4JSecurityDialog(Frame owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    public Olap4JSecurityDialog(Dialog owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext context) {
        this.setTitle(Messages.getString("Olap4JSecurityDialog.Title", new Object[0]));
        String[] reportFields = context.getDataSchemaModel().getColumnNames();
        this.jdbcPasswordFieldBox = new JComboBox<String>(reportFields);
        this.jdbcPasswordFieldBox.setEditable(true);
        this.jdbcUserFieldBox = new JComboBox<String>(reportFields);
        this.jdbcUserFieldBox.setEditable(true);
        this.roleFieldBox = new JComboBox<String>(reportFields);
        this.roleFieldBox.setEditable(true);
        super.init();
    }

    protected String getDialogId() {
        return "Olap4JDataSourceEditor.Security";
    }

    protected Component createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)new JLabel(Messages.getString("Olap4JSecurityDialog.Role.FieldValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        contentPane.add((Component)this.roleFieldBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)new JLabel(Messages.getString("Olap4JSecurityDialog.JDBCUser.FieldValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        contentPane.add((Component)this.jdbcUserFieldBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)new JLabel(Messages.getString("Olap4JSecurityDialog.JDBCPassword.FieldValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        contentPane.add((Component)this.jdbcPasswordFieldBox, gbc);
        return contentPane;
    }

    public String getJdbcUserField() {
        Object o = this.jdbcUserFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setJdbcUserField(String jdbcUserField) {
        this.jdbcUserFieldBox.setSelectedItem(jdbcUserField);
    }

    public String getJdbcPasswordField() {
        Object o = this.jdbcPasswordFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setJdbcPasswordField(String jdbcPasswordField) {
        this.jdbcPasswordFieldBox.setSelectedItem(jdbcPasswordField);
    }

    public String getRoleField() {
        Object o = this.roleFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setRoleField(String jdbcPasswordField) {
        this.roleFieldBox.setSelectedItem(jdbcPasswordField);
    }

    public boolean performEdit() {
        return super.performEdit();
    }
}

