/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.adminsettings;

import com.google.gdata.client.appsforyourdomain.AppsPropertyService;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DomainSettingsService
extends AppsPropertyService {
    protected String generalSettingsUrl = null;
    protected String domainBaseUrl = null;
    protected String appearanceUrl = null;
    protected String accountSettingsUrl = null;

    public DomainSettingsService(String domain, String applicationName) {
        super(applicationName);
        this.domainBaseUrl = "https://apps-apis.google.com/a/feeds/domain/2.0/" + domain + "/";
        this.accountSettingsUrl = this.domainBaseUrl + "accountInformation/";
        this.generalSettingsUrl = this.domainBaseUrl + "general/";
        this.appearanceUrl = this.domainBaseUrl + "appearance/";
    }

    public DomainSettingsService(String adminUser, String adminPassword, String domain, String applicationName) throws AuthenticationException {
        this(domain, applicationName);
        this.setUserCredentials(adminUser, adminPassword);
    }

    public GenericEntry setDefaultLanguage(String language) throws AppsForYourDomainException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("defaultLanguage", language);
        return this.update(new URL(this.generalSettingsUrl + "defaultLanguage"), entry);
    }

    public String getDefaultLanguage() throws AppsForYourDomainException, IOException, ServiceException {
        return this.getEntry(new URL(this.generalSettingsUrl + "defaultLanguage"), GenericEntry.class).getProperty("defaultLanguage");
    }

    public GenericEntry setOrganizationName(String organizationName) throws AppsForYourDomainException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("organizationName", organizationName);
        return this.update(new URL(this.generalSettingsUrl + "organizationName"), entry);
    }

    public String getOrganizationName() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.generalSettingsUrl + "organizationName"), GenericEntry.class).getProperty("organizationName");
    }

    public int getMaxUserCount() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        String usersCount = this.getEntry(new URL(this.generalSettingsUrl + "maximumNumberOfUsers"), GenericEntry.class).getProperty("maximumNumberOfUsers");
        return Integer.parseInt(usersCount);
    }

    public String getDomainVerificationStatus() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "isVerified"), GenericEntry.class).getProperty("isVerified");
    }

    public String getSupportPIN() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "supportPIN"), GenericEntry.class).getProperty("supportPIN");
    }

    public String getDomainEdition() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "edition"), GenericEntry.class).getProperty("edition");
    }

    public String getCustomerPIN() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "customerPIN"), GenericEntry.class).getProperty("customerPIN");
    }

    public String getDomainCreationTime() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "creationTime"), GenericEntry.class).getProperty("creationTime");
    }

    public String getCountryCodeForDomain() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "countryCode"), GenericEntry.class).getProperty("countryCode");
    }

    public String getDomainSecondaryEmailAddress() throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL(this.accountSettingsUrl + "adminSecondaryEmail"), GenericEntry.class).getProperty("adminSecondaryEmail");
    }

    public GenericEntry setDomainSecondaryEmailAddress(String adminSecondaryEmail) throws AppsForYourDomainException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("adminSecondaryEmail", adminSecondaryEmail);
        return this.update(new URL(this.accountSettingsUrl + "adminSecondaryEmail"), entry);
    }

    public GenericEntry setDomainLogo(String base64EncodedImage) throws IOException, AppsForYourDomainException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("logoImage", base64EncodedImage);
        return this.update(new URL(this.appearanceUrl + "customLogo"), entry);
    }
}

