/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media.mediarss;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCopyright;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaDescription;
import com.google.gdata.data.media.mediarss.MediaHash;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaPlayer;
import com.google.gdata.data.media.mediarss.MediaRating;
import com.google.gdata.data.media.mediarss.MediaRestriction;
import com.google.gdata.data.media.mediarss.MediaRssNamespace;
import com.google.gdata.data.media.mediarss.MediaText;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.media.mediarss.MediaTitle;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExtensionDescription.Default(nsAlias="media", nsUri="http://search.yahoo.com/mrss/", localName="group")
public class MediaGroup
extends ExtensionPoint
implements Extension {
    public static ExtensionDescription getDefaultDescription() {
        return ExtensionDescription.getDefaultDescription(MediaGroup.class);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        MediaRssNamespace.declareAll(extProfile);
    }

    public List<MediaContent> getContents() {
        return this.getRepeatingExtension(MediaContent.class);
    }

    public void clearContents() {
        this.getContents().clear();
    }

    public void addContent(MediaContent content) {
        this.addRepeatingExtension(content);
    }

    public List<MediaCategory> getCategories() {
        return this.getRepeatingExtension(MediaCategory.class);
    }

    public Set<MediaCategory> getCategoriesWithScheme(String scheme) {
        HashSet<MediaCategory> result = new HashSet<MediaCategory>();
        for (MediaCategory category : this.getCategories()) {
            if ((scheme != null || category.getScheme() != null) && (scheme == null || !scheme.equals(category.getScheme()))) continue;
            result.add(category);
        }
        return Collections.unmodifiableSet(result);
    }

    public void clearCategories() {
        this.getCategories().clear();
    }

    public void addCategory(MediaCategory category) {
        this.getCategories().add(category);
    }

    public MediaCopyright getCopyright() {
        return this.getExtension(MediaCopyright.class);
    }

    public void setCopyright(MediaCopyright copyright) {
        if (copyright == null) {
            this.removeExtension(MediaCopyright.class);
        } else {
            this.setExtension(copyright);
        }
    }

    public List<MediaCredit> getCredits() {
        return this.getRepeatingExtension(MediaCredit.class);
    }

    public void clearCredits() {
        this.getCredits().clear();
    }

    public void addCredit(MediaCredit credit) {
        this.getCredits().add(credit);
    }

    public MediaHash getHash() {
        return this.getExtension(MediaHash.class);
    }

    public void setHash(MediaHash hash) {
        if (hash == null) {
            this.removeExtension(MediaHash.class);
        } else {
            this.setExtension(hash);
        }
    }

    public MediaKeywords getKeywords() {
        return this.getExtension(MediaKeywords.class);
    }

    public void setKeywords(MediaKeywords keywords) {
        if (keywords == null) {
            this.removeExtension(MediaKeywords.class);
        } else {
            this.setExtension(keywords);
        }
    }

    public MediaPlayer getPlayer() {
        return this.getExtension(MediaPlayer.class);
    }

    public void setPlayer(MediaPlayer player) {
        if (player == null) {
            this.removeExtension(MediaPlayer.class);
        } else {
            this.setExtension(player);
        }
    }

    public List<MediaRating> getRatings() {
        return this.getRepeatingExtension(MediaRating.class);
    }

    public void clearRatings() {
        this.getRatings().clear();
    }

    public void addRating(MediaRating rating) {
        this.getRatings().add(rating);
    }

    public List<MediaThumbnail> getThumbnails() {
        return this.getRepeatingExtension(MediaThumbnail.class);
    }

    public void clearThumbnails() {
        this.getThumbnails().clear();
    }

    public void addThumbnail(MediaThumbnail thumbnail) {
        this.getThumbnails().add(thumbnail);
    }

    public List<MediaText> getTexts() {
        return this.getRepeatingExtension(MediaText.class);
    }

    public void clearTexts() {
        this.getTexts().clear();
    }

    public void addText(MediaText text) {
        this.getTexts().add(text);
    }

    public List<MediaRestriction> getRestrictions() {
        return this.getRepeatingExtension(MediaRestriction.class);
    }

    public void clearRestrictions() {
        this.getRestrictions().clear();
    }

    public void addRestriction(MediaRestriction restriction) {
        this.getRestrictions().add(restriction);
    }

    public void setTitle(MediaTitle title) {
        if (title == null) {
            this.removeExtension(MediaTitle.class);
        } else {
            this.setExtension(title);
        }
    }

    public MediaTitle getTitle() {
        return this.getExtension(MediaTitle.class);
    }

    public void setDescription(MediaDescription description) {
        if (description == null) {
            this.removeExtension(MediaDescription.class);
        } else {
            this.setExtension(description);
        }
    }

    public MediaDescription getDescription() {
        return this.getExtension(MediaDescription.class);
    }
}

