/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create View")
public class CreateViewDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String viewName;
    private String originalText;
    private String expandedText;
    private List<FieldSchema> schema;
    private Map<String, String> tblProps;
    private String comment;
    private boolean ifNotExists;

    public CreateViewDesc() {
    }

    public CreateViewDesc(String viewName, List<FieldSchema> schema, String comment, Map<String, String> tblProps, boolean ifNotExists) {
        this.viewName = viewName;
        this.schema = schema;
        this.comment = comment;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="name")
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Explain(displayName="original text")
    public String getViewOriginalText() {
        return this.originalText;
    }

    public void setViewOriginalText(String originalText) {
        this.originalText = originalText;
    }

    @Explain(displayName="expanded text")
    public String getViewExpandedText() {
        return this.expandedText;
    }

    public void setViewExpandedText(String expandedText) {
        this.expandedText = expandedText;
    }

    @Explain(displayName="columns")
    public List<String> getSchemaString() {
        return Utilities.getFieldSchemaString(this.schema);
    }

    public List<FieldSchema> getSchema() {
        return this.schema;
    }

    public void setSchema(List<FieldSchema> schema) {
        this.schema = schema;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    @Explain(displayName="if not exists")
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }
}

