/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.DynamicLoginConfiguration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.login.HadoopLoginModule;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.PlatformName;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "HBase", "Hive", "Oozie"})
@InterfaceStability.Evolving
public class UserGroupInformation {
    private static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    static final String HADOOP_USER_NAME = "HADOOP_USER_NAME";
    static final String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
    private static final String HADOOP_SECURITY_SPOOF_USER = "hadoop.spoof.user";
    private static final String HADOOP_SECURITY_SPOOFED_USER = "hadoop.spoofed.user.username";
    private static boolean spoofUser = false;
    private static String spoofedUser;
    static UgiMetrics metrics;
    private static AuthenticationMethod authenticationMethod;
    private static Groups groups;
    private static Configuration conf;
    private static String userJAASConfName;
    private static String serviceJAASConfName;
    private static final long MIN_TIME_BEFORE_RELOGIN = 600000L;
    public static final String HADOOP_TOKEN_FILE_LOCATION = "HADOOP_TOKEN_FILE_LOCATION";
    private static Class<? extends Principal> customAuthPrincipalClass;
    private static Class<? extends RpcAuthMethod> customRpcAuthMethodClass;
    public static final String USER_TICKET_FILE_LOCATION = "MAPR_TICKETFILE_LOCATION";
    private static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static UserGroupInformation loginUser;
    private static String keytabPrincipal;
    private static String keytabFile;
    private final Subject subject;
    private final User user;
    private final boolean isKeytab;
    private final boolean isKrbTkt;
    private List<RpcAuthMethod> rpcAuthMethodList;
    private static final boolean windows;

    private static void checkSpoofing(Configuration conf) {
        spoofUser = conf.getBoolean(HADOOP_SECURITY_SPOOF_USER, windows);
        if (!spoofUser) {
            return;
        }
        spoofedUser = conf.get(HADOOP_SECURITY_SPOOFED_USER, "root");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized() {
        if (conf != null) return;
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            if (conf != null) return;
            UserGroupInformation.initialize(new Configuration(), false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void initialize(Configuration conf, boolean overrideNameRules) {
        int[] intervals;
        String loginConfPath;
        authenticationMethod = SecurityUtil.getAuthenticationMethod(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HADOOP_SECURITY_AUTHENTICATION is set to: " + (Object)((Object)authenticationMethod)));
        }
        if (authenticationMethod == null || authenticationMethod.equals((Object)AuthenticationMethod.SIMPLE)) {
            UserGroupInformation.checkSpoofing(conf);
        } else {
            customAuthPrincipalClass = SecurityUtil.getCustomAuthPrincipal(conf);
            customRpcAuthMethodClass = SecurityUtil.getCustomRpcAuthMethod(conf);
        }
        String jaasConfName = null;
        if (authenticationMethod == AuthenticationMethod.SIMPLE) {
            jaasConfName = "simple";
        } else {
            LOG.debug((Object)"Security is enabled.");
            jaasConfName = System.getProperty("hadoop.login");
            if (jaasConfName == null) {
                jaasConfName = conf.get("hadoop.login", "default");
            }
        }
        userJAASConfName = jaasConfName.startsWith("hadoop_") ? jaasConfName : "hadoop_" + jaasConfName;
        String string = serviceJAASConfName = userJAASConfName.endsWith("_keytab") ? userJAASConfName : userJAASConfName + "_keytab";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Login configuration entry is " + userJAASConfName));
        }
        if ((loginConfPath = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG)) == null && (loginConfPath = conf.get(JAVA_SECURITY_AUTH_LOGIN_CONFIG)) != null) {
            System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, loginConfPath);
            loginConfPath = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            LOG.info((Object)("Java System property 'java.security.auth.login.config' not set, unilaterally setting to " + loginConfPath));
        }
        if (loginConfPath == null || !new File(loginConfPath).canRead()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(loginConfPath + " either null or can not be read. Trying to load " + "'java.security.auth.login.config' from jar"));
            }
            String javaSecurityJarPath = conf.get("hadoop.security.java.security.login.config.jar.path");
            URL javaSecurityURL = null;
            if (javaSecurityJarPath != null && (javaSecurityURL = UserGroupInformation.class.getResource(javaSecurityJarPath)) != null) {
                loginConfPath = javaSecurityURL.toExternalForm();
                System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, loginConfPath);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading 'java.security.auth.login.config' from: " + loginConfPath));
                }
            }
            if (javaSecurityJarPath == null || javaSecurityURL == null) {
                LOG.warn((Object)"'java.security.auth.login.config' is not configured either in Hadoop configuration or via Java property or not loaded from jar, may cause login failure");
            }
        }
        if (overrideNameRules || !HadoopKerberosName.hasRulesBeenSet()) {
            try {
                HadoopKerberosName.setConfiguration(conf);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem with Kerberos auth_to_local name configuration", ioe);
            }
        }
        if (!(groups instanceof TestingGroups)) {
            groups = Groups.getUserToGroupsMappingService(conf);
        }
        UserGroupInformation.conf = conf;
        if (UserGroupInformation.metrics.getGroupsQuantiles == null && (intervals = conf.getInts("hadoop.user.group.metrics.percentiles.intervals")) != null && intervals.length > 0) {
            int length = intervals.length;
            MutableQuantiles[] getGroupsQuantiles = new MutableQuantiles[length];
            for (int i = 0; i < length; ++i) {
                getGroupsQuantiles[i] = UserGroupInformation.metrics.registry.newQuantiles("getGroups" + intervals[i] + "s", "Get groups", "ops", "latency", intervals[i]);
            }
            UserGroupInformation.metrics.getGroupsQuantiles = getGroupsQuantiles;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void setConfiguration(Configuration conf) {
        UserGroupInformation.initialize(conf, true);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static void reset() {
        authenticationMethod = null;
        conf = null;
        groups = null;
        UserGroupInformation.setLoginUser(null);
        HadoopKerberosName.setRules(null);
    }

    public static boolean isSecurityEnabled() {
        return !UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.SIMPLE);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    private static boolean isAuthenticationMethodEnabled(AuthenticationMethod method) {
        UserGroupInformation.ensureInitialized();
        return authenticationMethod == method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoginContext newLoginContext(String appName, Subject subject, Map<String, ?> overrideOptions) throws LoginException {
        Thread t = Thread.currentThread();
        ClassLoader oldCCL = t.getContextClassLoader();
        t.setContextClassLoader(HadoopLoginModule.class.getClassLoader());
        try {
            if (overrideOptions != null) {
                DynamicLoginConfiguration cfg = new DynamicLoginConfiguration(UserGroupInformation.getJAASConf(), overrideOptions);
                LoginContext loginContext = new LoginContext(appName, subject, null, cfg);
                return loginContext;
            }
            LoginContext loginContext = new LoginContext(appName, subject);
            return loginContext;
        }
        finally {
            t.setContextClassLoader(oldCCL);
        }
    }

    private static LoginContext newLoginContextWithKeyTab(String appName, Subject subject, String keytab, String principal) throws LoginException {
        HashMap<String, String> overrideOptions = new HashMap<String, String>();
        overrideOptions.put("keyTab", keytab);
        overrideOptions.put("principal", principal);
        return UserGroupInformation.newLoginContext(appName, subject, overrideOptions);
    }

    private static javax.security.auth.login.Configuration getJAASConf() {
        return javax.security.auth.login.Configuration.getConfiguration();
    }

    private LoginContext getLogin() {
        return this.user.getLogin();
    }

    private void setLogin(LoginContext login) {
        this.user.setLogin(login);
    }

    private void configureRpcAuthMethods(String confName) {
        ArrayList authMethodList = new ArrayList();
        if (UserGroupInformation.isSecurityEnabled() && confName != null) {
            LinkedHashSet<RpcAuthMethod> authMethods = new LinkedHashSet<RpcAuthMethod>();
            AppConfigurationEntry[] appInfo = UserGroupInformation.getJAASConf().getAppConfigurationEntry(confName);
            for (int i = 0; appInfo != null && i < appInfo.length; ++i) {
                String module = appInfo[i].getLoginModuleName();
                RpcAuthMethod rpcAuthMethod = RpcAuthRegistry.getAuthMethodForLoginModule(module);
                if (rpcAuthMethod == null) continue;
                authMethods.add(rpcAuthMethod);
            }
            authMethods.add(RpcAuthRegistry.getAuthMethod(authenticationMethod));
            if (UserGroupInformation.isSecurityEnabled() && !"hadoop_simple".equals(confName) && authMethods.size() == 0) {
                LOG.warn((Object)("Security is enabled but no suitable RPC authentication method is found in the provided JAAS configuration: " + confName));
            }
            authMethodList.addAll(authMethods);
        } else {
            authMethodList.add(RpcAuthRegistry.SIMPLE);
        }
        this.rpcAuthMethodList = Collections.unmodifiableList(authMethodList);
    }

    UserGroupInformation(Subject subject) {
        this(subject, userJAASConfName);
    }

    UserGroupInformation(Subject subject, String loginConfName) {
        this.subject = subject;
        this.user = subject.getPrincipals(User.class).iterator().next();
        this.isKeytab = !subject.getPrivateCredentials(KerberosKey.class).isEmpty();
        this.isKrbTkt = !subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        this.configureRpcAuthMethods(loginConfName);
        if (!subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
            this.user.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
            LOG.debug((Object)"found Kerberos Principal in subject, marking as such");
        } else if (customAuthPrincipalClass != null && !subject.getPrincipals(customAuthPrincipalClass).isEmpty()) {
            this.user.setAuthenticationMethod(AuthenticationMethod.CUSTOM);
            LOG.debug((Object)("found custom auth principal " + customAuthPrincipalClass.getName() + "  in subject. " + "marking authentication method as " + (Object)((Object)AuthenticationMethod.CUSTOM)));
        }
    }

    public boolean hasKerberosCredentials() {
        return this.isKeytab || this.isKrbTkt;
    }

    public List<RpcAuthMethod> getRpcAuthMethodList() {
        return this.rpcAuthMethodList;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized UserGroupInformation getCurrentUser() throws IOException {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject == null || subject.getPrincipals(User.class).isEmpty()) {
            return UserGroupInformation.getLoginUser();
        }
        return new UserGroupInformation(subject);
    }

    public static UserGroupInformation getBestUGI(String ticketCachePath, String user) throws IOException {
        if (ticketCachePath != null) {
            return UserGroupInformation.getUGIFromTicketCache(ticketCachePath, user);
        }
        if (user == null) {
            return UserGroupInformation.getCurrentUser();
        }
        return UserGroupInformation.createRemoteUser(user);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getUGIFromTicketCache(String ticketCache, String user) throws IOException {
        if (!UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.KERBEROS)) {
            return UserGroupInformation.getBestUGI(null, user);
        }
        try {
            HashMap<String, String> krbOptions = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                krbOptions.put("useDefaultCcache", "true");
                System.setProperty("KRB5CCNAME", ticketCache);
            } else {
                krbOptions.put("ticketCache", ticketCache);
            }
            krbOptions.put("renewTGT", "false");
            LoginContext login = UserGroupInformation.newLoginContext(userJAASConfName, null, krbOptions);
            login.login();
            Subject loginSubject = login.getSubject();
            Set<Principal> loginPrincipals = loginSubject.getPrincipals();
            if (loginPrincipals.isEmpty()) {
                throw new RuntimeException("No login principals found!");
            }
            if (loginPrincipals.size() != 1) {
                LOG.warn((Object)("found more than one principal in the ticket cache file " + ticketCache));
            }
            User ugiUser = new User(loginPrincipals.iterator().next().getName(), AuthenticationMethod.KERBEROS, login);
            loginSubject.getPrincipals().add(ugiUser);
            UserGroupInformation ugi = new UserGroupInformation(loginSubject);
            ugi.setLogin(login);
            ugi.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
            return ugi;
        }
        catch (LoginException le) {
            throw new IOException("failure to login using ticket cache file " + ticketCache, le);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized UserGroupInformation getLoginUser() throws IOException {
        if (loginUser == null) {
            UserGroupInformation.loginUserFromSubject(null);
        }
        return loginUser;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized void loginUserFromSubject(Subject subject) throws IOException {
        UserGroupInformation.ensureInitialized();
        try {
            if (subject == null) {
                subject = new Subject();
            }
            LoginContext login = UserGroupInformation.newLoginContext(userJAASConfName, subject, null);
            login.login();
            UserGroupInformation realUser = new UserGroupInformation(subject, userJAASConfName);
            realUser.setLogin(login);
            UserGroupInformation.setUserAuthenticationMethod(realUser);
            realUser = new UserGroupInformation(login.getSubject(), userJAASConfName);
            String proxyUser = System.getenv(HADOOP_PROXY_USER);
            if (proxyUser == null) {
                proxyUser = System.getProperty(HADOOP_PROXY_USER);
            }
            loginUser = proxyUser == null ? realUser : UserGroupInformation.createProxyUser(proxyUser, realUser);
            String fileLocation = System.getenv(HADOOP_TOKEN_FILE_LOCATION);
            if (fileLocation != null) {
                Credentials cred = Credentials.readTokenStorageFile(new File(fileLocation), conf);
                loginUser.addCredentials(cred);
            }
            loginUser.spawnAutoRenewalThreadForUserCreds();
        }
        catch (LoginException le) {
            LOG.debug((Object)"failure to login", (Throwable)le);
            throw new IOException("failure to login: " + le.getMessage(), le);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("UGI loginUser:" + loginUser));
        }
    }

    private static void setUserAuthenticationMethod(UserGroupInformation realUser) {
        if (realUser.user.getAuthenticationMethod() == null) {
            switch (authenticationMethod) {
                case TOKEN: 
                case CERTIFICATE: 
                case KERBEROS_SSL: 
                case PROXY: {
                    throw new UnsupportedOperationException((Object)((Object)authenticationMethod) + " login authentication is not supported");
                }
            }
            LOG.debug((Object)"Found no authentication principals in subject. Simple?");
            realUser.user.setAuthenticationMethod(authenticationMethod);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public static synchronized void setLoginUser(UserGroupInformation ugi) {
        loginUser = ugi;
    }

    public boolean isFromKeytab() {
        return this.isKeytab;
    }

    private synchronized KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!SecurityUtil.isOriginalTGT(ticket)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found tgt " + ticket));
            }
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    private void spawnAutoRenewalThreadForUserCreds() {
        if (UserGroupInformation.isSecurityEnabled() && this.user.getAuthenticationMethod() == AuthenticationMethod.KERBEROS && !this.isKeytab) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    String cmd = conf.get("hadoop.kerberos.kinit.command", "kinit");
                    KerberosTicket tgt = UserGroupInformation.this.getTGT();
                    if (tgt == null) {
                        return;
                    }
                    long nextRefresh = UserGroupInformation.this.getRefreshTime(tgt);
                    try {
                        while (true) {
                            long now = Time.now();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Current time is " + now));
                                LOG.debug((Object)("Next refresh is " + nextRefresh));
                            }
                            if (now < nextRefresh) {
                                Thread.sleep(nextRefresh - now);
                            }
                            Shell.execCommand(cmd, "-R");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"renewed ticket");
                            }
                            UserGroupInformation.this.reloginFromTicketCache();
                            tgt = UserGroupInformation.this.getTGT();
                            if (tgt == null) {
                                LOG.warn((Object)("No TGT after renewal. Aborting renew thread for " + UserGroupInformation.this.getUserName()));
                                return;
                            }
                            nextRefresh = Math.max(UserGroupInformation.this.getRefreshTime(tgt), now + 600000L);
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.warn((Object)"Terminating renewal thread");
                        return;
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Exception encountered while running the renewal command. Aborting renew thread. " + ie));
                        return;
                    }
                }
            });
            t.setDaemon(true);
            t.setName("TGT Renewer for " + this.getUserName());
            t.start();
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized void loginUserFromKeytab(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        keytabFile = path;
        keytabPrincipal = user;
        Subject subject = new Subject();
        long start = 0L;
        try {
            LoginContext login = UserGroupInformation.newLoginContextWithKeyTab(serviceJAASConfName, subject, keytabFile, keytabPrincipal);
            start = Time.now();
            login.login();
            UserGroupInformation.metrics.loginSuccess.add(Time.now() - start);
            loginUser = new UserGroupInformation(subject, serviceJAASConfName);
            loginUser.setLogin(login);
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.add(Time.now() - start);
            }
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
        LOG.info((Object)("Login successful for user " + keytabPrincipal + " using keytab file " + keytabFile));
    }

    public synchronized void checkTGTAndReloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKeytab) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt != null && Time.now() < this.getRefreshTime(tgt)) {
            return;
        }
        this.reloginFromKeytab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public synchronized void reloginFromKeytab() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKeytab) {
            return;
        }
        long now = Time.now();
        if (!this.hasSufficientTimeElapsed(now)) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt != null && now < this.getRefreshTime(tgt)) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null || keytabFile == null) {
            throw new IOException("loginUserFromKeyTab must be done first");
        }
        long start = 0L;
        this.user.setLastLogin(now);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initiating logout for " + this.getUserName()));
            }
            Class<UserGroupInformation> clazz = UserGroupInformation.class;
            synchronized (UserGroupInformation.class) {
                login.logout();
                login = UserGroupInformation.newLoginContextWithKeyTab(serviceJAASConfName, this.getSubject(), keytabFile, keytabPrincipal);
                LOG.info((Object)("Initiating re-login for " + keytabPrincipal));
                start = Time.now();
                login.login();
                UserGroupInformation.metrics.loginSuccess.add(Time.now() - start);
                this.setLogin(login);
                // ** MonitorExit[var7_5] (shouldn't be in output)
            }
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.add(Time.now() - start);
            }
            throw new IOException("Login failure for " + keytabPrincipal + " from keytab " + keytabFile, le);
        }
        {
            return;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public synchronized void reloginFromTicketCache() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled() || this.user.getAuthenticationMethod() != AuthenticationMethod.KERBEROS || !this.isKrbTkt) {
            return;
        }
        LoginContext login = this.getLogin();
        if (login == null) {
            throw new IOException("login must be done first");
        }
        long now = Time.now();
        if (!this.hasSufficientTimeElapsed(now)) {
            return;
        }
        this.user.setLastLogin(now);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initiating logout for " + this.getUserName()));
            }
            login.logout();
            login = UserGroupInformation.newLoginContext(userJAASConfName, this.getSubject(), null);
            LOG.info((Object)("Initiating re-login for " + this.getUserName()));
            login.login();
            this.setLogin(login);
        }
        catch (LoginException le) {
            throw new IOException("Login failure for " + this.getUserName(), le);
        }
    }

    public static synchronized UserGroupInformation loginUserFromKeytabAndReturnUGI(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return UserGroupInformation.getCurrentUser();
        }
        String oldKeytabFile = null;
        String oldKeytabPrincipal = null;
        long start = 0L;
        try {
            oldKeytabFile = keytabFile;
            oldKeytabPrincipal = keytabPrincipal;
            keytabFile = path;
            keytabPrincipal = user;
            Subject subject = new Subject();
            LoginContext login = UserGroupInformation.newLoginContextWithKeyTab(serviceJAASConfName, subject, keytabFile, keytabPrincipal);
            start = Time.now();
            login.login();
            UserGroupInformation.metrics.loginSuccess.add(Time.now() - start);
            UserGroupInformation newLoginUser = new UserGroupInformation(subject, serviceJAASConfName);
            newLoginUser.setLogin(login);
            UserGroupInformation userGroupInformation = newLoginUser;
            return userGroupInformation;
        }
        catch (LoginException le) {
            if (start > 0L) {
                UserGroupInformation.metrics.loginFailure.add(Time.now() - start);
            }
            throw new IOException("Login failure for " + user + " from keytab " + path, le);
        }
        finally {
            if (oldKeytabFile != null) {
                keytabFile = oldKeytabFile;
            }
            if (oldKeytabPrincipal != null) {
                keytabPrincipal = oldKeytabPrincipal;
            }
        }
    }

    private boolean hasSufficientTimeElapsed(long now) {
        if (now - this.user.getLastLogin() < 600000L) {
            LOG.warn((Object)"Not attempting to re-login since the last re-login was attempted less than 600 seconds before.");
            return false;
        }
        return true;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static synchronized boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.getLoginUser().isKeytab;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(AuthenticationMethod.SIMPLE);
        return result;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createProxyUser(String user, UserGroupInformation realUser) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        if (realUser == null) {
            throw new IllegalArgumentException("Null real user");
        }
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new User(user));
        principals.add(new RealUser(realUser));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(AuthenticationMethod.PROXY);
        return result;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public UserGroupInformation getRealUser() {
        Iterator<RealUser> i$ = this.subject.getPrincipals(RealUser.class).iterator();
        if (i$.hasNext()) {
            RealUser p = i$.next();
            return p.getRealUser();
        }
        return null;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createUserForTesting(String user, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public static UserGroupInformation createProxyUserForTesting(String user, UserGroupInformation realUser, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser(user, realUser);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)UserGroupInformation.groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public String getShortUserName() {
        if (windows && spoofUser) {
            return spoofedUser;
        }
        Iterator<User> i$ = this.subject.getPrincipals(User.class).iterator();
        if (i$.hasNext()) {
            User p = i$.next();
            return p.getShortName();
        }
        return null;
    }

    public String getPrimaryGroupName() throws IOException {
        String[] groups = this.getGroupNames();
        if (groups.length == 0) {
            throw new IOException("There is no primary group for UGI " + this);
        }
        return groups[0];
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public String getUserName() {
        if (windows && spoofUser) {
            return spoofedUser;
        }
        return this.user.getName();
    }

    public synchronized boolean addTokenIdentifier(TokenIdentifier tokenId) {
        return this.subject.getPublicCredentials().add(tokenId);
    }

    public synchronized Set<TokenIdentifier> getTokenIdentifiers() {
        return this.subject.getPublicCredentials(TokenIdentifier.class);
    }

    public synchronized boolean addToken(Token<? extends TokenIdentifier> token) {
        return token != null ? this.addToken(token.getService(), token) : false;
    }

    public synchronized boolean addToken(Text alias, Token<? extends TokenIdentifier> token) {
        this.getCredentialsInternal().addToken(alias, token);
        return true;
    }

    public synchronized Collection<Token<? extends TokenIdentifier>> getTokens() {
        return Collections.unmodifiableCollection(this.getCredentialsInternal().getAllTokens());
    }

    public synchronized Credentials getCredentials() {
        Credentials creds = new Credentials(this.getCredentialsInternal());
        Iterator<Token<? extends TokenIdentifier>> iter = creds.getAllTokens().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof Token.PrivateToken)) continue;
            iter.remove();
        }
        return creds;
    }

    public synchronized void addCredentials(Credentials credentials) {
        this.getCredentialsInternal().addAll(credentials);
    }

    private synchronized Credentials getCredentialsInternal() {
        Credentials credentials;
        Set<Credentials> credentialsSet = this.subject.getPrivateCredentials(Credentials.class);
        if (!credentialsSet.isEmpty()) {
            credentials = credentialsSet.iterator().next();
        } else {
            credentials = new Credentials();
            this.subject.getPrivateCredentials().add(credentials);
        }
        return credentials;
    }

    public synchronized String[] getGroupNames() {
        UserGroupInformation.ensureInitialized();
        try {
            List<String> result = groups.getGroups(this.getShortUserName());
            return result.toArray(new String[result.size()]);
        }
        catch (IOException ie) {
            LOG.warn((Object)("No groups available for user " + this.getShortUserName()));
            return new String[0];
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUserName());
        sb.append(" (auth:" + (Object)((Object)this.getAuthenticationMethod()) + ")");
        if (this.getRealUser() != null) {
            sb.append(" via ").append(this.getRealUser().toString());
        }
        return sb.toString();
    }

    public synchronized void setAuthenticationMethod(AuthenticationMethod authMethod) {
        this.user.setAuthenticationMethod(authMethod);
    }

    public void setAuthenticationMethod(SaslRpcServer.AuthMethod authMethod) {
        switch (authMethod) {
            case SIMPLE: {
                this.user.setAuthenticationMethod(AuthenticationMethod.SIMPLE);
                break;
            }
            case KERBEROS: {
                this.user.setAuthenticationMethod(AuthenticationMethod.KERBEROS);
                break;
            }
            case DIGEST: 
            case TOKEN: {
                this.user.setAuthenticationMethod(AuthenticationMethod.TOKEN);
                break;
            }
            default: {
                this.user.setAuthenticationMethod(null);
            }
        }
    }

    public synchronized AuthenticationMethod getAuthenticationMethod() {
        return this.user.getAuthenticationMethod();
    }

    public synchronized AuthenticationMethod getRealAuthenticationMethod() {
        UserGroupInformation ugi = this.getRealUser();
        if (ugi == null) {
            ugi = this;
        }
        return ugi.getAuthenticationMethod();
    }

    public static AuthenticationMethod getRealAuthenticationMethod(UserGroupInformation ugi) {
        AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.subject == ((UserGroupInformation)o).subject;
    }

    public int hashCode() {
        return System.identityHashCode(this.subject);
    }

    public Subject getSubject() {
        return this.subject;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedAction<T> action) {
        this.logPrivilegedAction(this.subject, action);
        return Subject.doAs(this.subject, action);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        try {
            this.logPrivilegedAction(this.subject, action);
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PrivilegedActionException as:" + this + " cause:" + cause));
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    private void logPrivilegedAction(Subject subject, Object action) {
        if (LOG.isDebugEnabled()) {
            String where = new Throwable().getStackTrace()[2].toString();
            LOG.debug((Object)("PrivilegedAction as:" + this + " from:" + where));
        }
    }

    private void print() throws IOException {
        System.out.println("User: " + this.getUserName());
        System.out.print("Group Ids: ");
        System.out.println();
        String[] groups = this.getGroupNames();
        System.out.print("Groups: ");
        for (int i = 0; i < groups.length; ++i) {
            System.out.print(groups[i] + " ");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting UGI for current user");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.print();
        System.out.println("UGI: " + ugi);
        System.out.println("Auth method " + (Object)((Object)ugi.user.getAuthenticationMethod()));
        System.out.println("Keytab " + ugi.isKeytab);
        System.out.println("============================================================");
        if (args.length == 2) {
            System.out.println("Getting UGI from keytab....");
            UserGroupInformation.loginUserFromKeytab(args[0], args[1]);
            UserGroupInformation.getCurrentUser().print();
            System.out.println("Keytab: " + ugi);
            System.out.println("Auth method " + (Object)((Object)UserGroupInformation.loginUser.user.getAuthenticationMethod()));
            System.out.println("Keytab " + UserGroupInformation.loginUser.isKeytab);
        }
    }

    static {
        metrics = UgiMetrics.create();
        loginUser = null;
        keytabPrincipal = null;
        keytabFile = null;
        windows = System.getProperty("os.name").startsWith("Windows");
    }

    private static class TestingGroups
    extends Groups {
        private final Map<String, List<String>> userToGroupsMapping = new HashMap<String, List<String>>();
        private Groups underlyingImplementation;

        private TestingGroups(Groups underlyingImplementation) {
            super(new Configuration());
            this.underlyingImplementation = underlyingImplementation;
        }

        @Override
        public List<String> getGroups(String user) throws IOException {
            List<String> result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = this.underlyingImplementation.getGroups(user);
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            this.userToGroupsMapping.put(user, Arrays.asList(groups));
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum AuthenticationMethod {
        SIMPLE(false),
        KERBEROS(true),
        TOKEN(false),
        CERTIFICATE(true),
        KERBEROS_SSL(true),
        PROXY(false),
        CUSTOM(true);

        private final boolean allowsDelegation;

        private AuthenticationMethod(boolean allowsDelegation) {
            this.allowsDelegation = allowsDelegation;
        }

        public boolean allowsDelegation() {
            return this.allowsDelegation;
        }
    }

    private static class RealUser
    implements Principal {
        private final UserGroupInformation realUser;

        RealUser(UserGroupInformation realUser) {
            this.realUser = realUser;
        }

        @Override
        public String getName() {
            return this.realUser.getUserName();
        }

        public UserGroupInformation getRealUser() {
            return this.realUser;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.realUser.equals(((RealUser)o).realUser);
        }

        @Override
        public int hashCode() {
            return this.realUser.hashCode();
        }

        @Override
        public String toString() {
            return this.realUser.toString();
        }
    }

    @Metrics(about="User and group related metrics", context="ugi")
    static class UgiMetrics {
        final MetricsRegistry registry = new MetricsRegistry("UgiMetrics");
        @Metric(value={"Rate of successful kerberos logins and latency (milliseconds)"})
        MutableRate loginSuccess;
        @Metric(value={"Rate of failed kerberos logins and latency (milliseconds)"})
        MutableRate loginFailure;
        @Metric(value={"GetGroups"})
        MutableRate getGroups;
        MutableQuantiles[] getGroupsQuantiles;

        UgiMetrics() {
        }

        static UgiMetrics create() {
            return DefaultMetricsSystem.instance().register(new UgiMetrics());
        }

        void addGetGroups(long latency) {
            this.getGroups.add(latency);
            if (this.getGroupsQuantiles != null) {
                for (MutableQuantiles q : this.getGroupsQuantiles) {
                    q.add(latency);
                }
            }
        }
    }
}

