/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.UpdateModel;
import nickyb.sqleonardo.environment.ctrl.define.TableMetaData;
import nickyb.sqleonardo.environment.io.FileStreamSQL;
import nickyb.sqleonardo.environment.io.FileStreamXLQ;
import nickyb.sqleonardo.environment.mdi.ClientContent;
import nickyb.sqleonardo.environment.mdi.DialogQuery;
import nickyb.sqleonardo.environment.mdi.MDIActions;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi.MDIMenubar;
import nickyb.sqleonardo.querybuilder.DiagramLayout;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class ClientQueryBuilder
extends MDIClient {
    public static final String DEFAULT_TITLE = "QUERY";
    public static int counter = 0;
    private QueryBuilder builder;
    private JMenuItem[] m_actions;
    private Toolbar toolbar;
    private String keycah = null;
    private String filename = null;

    public ClientQueryBuilder(String keycah) {
        super(DEFAULT_TITLE);
        this.setMaximizable(false);
        this.setResizable(false);
        this.builder = new QueryBuilder();
        this.setComponentCenter(this.builder);
        this.keycah = keycah;
        this.createToolbar();
        this.initMenuActions();
        if (keycah != null) {
            this.builder.setConnection(ConnectionAssistant.getHandler(keycah).get());
        }
        this.setFileName(null);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent ife) {
                ClientQueryBuilder.this.setQueryParameters();
            }
        });
    }

    private void createToolbar() {
        JButton btn = new JButton(this.builder.getActionMap().get("diagram-save-as-image"));
        btn.setIcon(Application.resources.getIcon("icon.152"));
        btn.setToolTipText("save as image");
        btn.setText(null);
        this.toolbar = new Toolbar(0);
        this.toolbar.add(new ActionLaunch());
        this.toolbar.add(new ActionSave());
        this.toolbar.add(btn);
        this.setComponentEast(this.toolbar);
    }

    private void initMenuActions() {
        JCheckBoxMenuItem cbxm = new JCheckBoxMenuItem(this.builder.getActionMap().get("fields-draggable"));
        cbxm.setSelected(this.builder.isDragAndDropEnabled());
        this.m_actions = new JMenuItem[]{cbxm, null, MDIMenubar.createItem(this.builder.getActionMap().get("entities-arrange")), MDIMenubar.createItem(this.builder.getActionMap().get("entities-pack")), MDIMenubar.createItem(this.builder.getActionMap().get("entities-remove")), null, MDIMenubar.createItem(this.builder.getActionMap().get("copy-syntax"))};
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return this.toolbar;
    }

    protected void setPreferences() {
    }

    public final void setFileName(String filename) {
        this.filename = filename;
        String filename2 = filename == null ? "<untitled" + ++counter + ">" : filename;
        super.setTitle(this.getID() + " - " + DEFAULT_TITLE + " : " + filename2 + " : " + this.keycah);
    }

    public final void setDiagramLayout(DiagramLayout layout) {
        this.builder.setDiagramLayout(layout);
    }

    private void setQueryParameters() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
    }

    public class ActionSave
    extends MDIActions.AbstractBase {
        private ActionSave() {
            this.setText(I18n.getString("application.saveQuery", "save query"));
            this.setIcon("icon.010");
            this.setTooltip(I18n.getString("application.saveQuery", "save query"));
        }

        private void saveAs() {
            Object[] ret = DialogQuery.showSave(ClientQueryBuilder.this.builder.getDiagramLayout());
            if (ret[0] != null) {
                ClientQueryBuilder.this.setFileName(ret[0].toString());
            }
        }

        private void replace() {
            try {
                QueryModel qm = ClientQueryBuilder.this.builder.getQueryModel();
                String fn = ClientQueryBuilder.this.filename;
                if (fn.endsWith(".sql")) {
                    FileStreamSQL.write(fn, qm);
                } else {
                    if (!fn.endsWith(".xlq")) {
                        fn = fn + ".xlq";
                    }
                    FileStreamXLQ.write(fn, ClientQueryBuilder.this.builder.getDiagramLayout());
                }
                ClientQueryBuilder.this.setFileName(fn);
            }
            catch (Exception e) {
                Application.println(e, true);
                e.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientQueryBuilder.this.filename == null) {
                this.saveAs();
            } else {
                String message = I18n.getFormattedString("application.message.replaceFile", "{0}\nreplace existing file?", new Object[]{"" + ClientQueryBuilder.this.filename});
                int ret = JOptionPane.showConfirmDialog(Application.window, message, "query.save", 1);
                if (ret == 0) {
                    this.replace();
                } else if (ret == 1) {
                    this.saveAs();
                }
            }
        }
    }

    private class ActionLaunch
    extends MDIActions.AbstractBase {
        private ActionLaunch() {
            super(I18n.getString("application.launchQuery", "launch query"));
            this.setIcon("icon.151");
            this.setTooltip(I18n.getString("application.launchQuery", "launch query"));
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientQueryBuilder.this.builder.getConnection() == null) {
                Application.alert("SQLeonardo", "no connection!");
                return;
            }
            int pos = ClientQueryBuilder.this.getTitle().indexOf(":");
            String subtitle = ClientQueryBuilder.this.getTitle().substring(pos);
            UpdateModel um = null;
            QueryModel qm = null;
            try {
                qm = (QueryModel)ClientQueryBuilder.this.builder.getQueryModel().clone();
            }
            catch (CloneNotSupportedException cnse) {
                qm = ClientQueryBuilder.this.builder.getQueryModel();
            }
            if (qm.getQueryExpression().getQuerySpecification().getFromClause().length == 1 && qm.getQueryExpression().getQuerySpecification().getFromClause()[0] instanceof QueryTokens.Table) {
                QueryTokens.Table qtoken = (QueryTokens.Table)qm.getQueryExpression().getQuerySpecification().getFromClause()[0];
                TableMetaData tmd = new TableMetaData(ClientQueryBuilder.this.keycah, qtoken.getSchema(), qtoken.getName());
                um = tmd.createUpdateModel();
                um.getTable().setAlias(qtoken.getAlias());
                QueryTokens._Expression[] e = qm.getQueryExpression().getQuerySpecification().getSelectList();
                for (int i = 0; i < um.getRowIdentifierCount(); ++i) {
                    QueryTokens.Column cpk = um.getRowIdentifier(i);
                    for (int j = 0; j < e.length; ++j) {
                        if (!(e[j] instanceof QueryTokens.Column)) continue;
                        QueryTokens.Column c = (QueryTokens.Column)e[j];
                        if (!cpk.getName().equalsIgnoreCase(c.getName())) continue;
                        cpk.setAlias(c.getAlias());
                    }
                }
            }
            ClientContent client = new ClientContent(ClientQueryBuilder.this.keycah, qm, um);
            client.setTitle("PREVIEW : " + subtitle);
            Application.window.add(client);
        }
    }
}

