/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl;

import java.net.InetAddress;
import org.productivity.java.syslog4j.SyslogCharSetIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.impl.AbstractSyslogServerConfig;
import org.productivity.java.syslog4j.server.impl.event.SyslogServerEvent;
import org.productivity.java.syslog4j.server.impl.event.structured.StructuredSyslogServerEvent;
import org.productivity.java.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogServer
implements SyslogServerIF {
    protected String syslogProtocol = null;
    protected AbstractSyslogServerConfig syslogServerConfig = null;
    protected Thread thread = null;
    protected boolean shutdown = false;

    public void initialize(String string, SyslogServerConfigIF syslogServerConfigIF) throws SyslogRuntimeException {
        this.syslogProtocol = string;
        try {
            this.syslogServerConfig = (AbstractSyslogServerConfig)syslogServerConfigIF;
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException(classCastException);
        }
        this.initialize();
    }

    public String getProtocol() {
        return this.syslogProtocol;
    }

    public SyslogServerConfigIF getConfig() {
        return this.syslogServerConfig;
    }

    protected abstract void initialize() throws SyslogRuntimeException;

    public void shutdown() throws SyslogRuntimeException {
        this.shutdown = true;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    protected static boolean isStructuredMessage(SyslogCharSetIF syslogCharSetIF, byte[] byArray) {
        String string = SyslogUtility.newString(syslogCharSetIF, byArray);
        int n = string.indexOf(62);
        return n != -1 && string.length() > n + 1 && Character.isDigit(string.charAt(n + 1));
    }

    protected static SyslogServerEventIF createEvent(SyslogServerConfigIF syslogServerConfigIF, byte[] byArray, int n, InetAddress inetAddress) {
        SyslogServerEvent syslogServerEvent = null;
        syslogServerEvent = syslogServerConfigIF.isUseStructuredData() && AbstractSyslogServer.isStructuredMessage(syslogServerConfigIF, byArray) ? new StructuredSyslogServerEvent(byArray, n, inetAddress) : new SyslogServerEvent(byArray, n, inetAddress);
        return syslogServerEvent;
    }
}

