/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.util.Hashtable;
import java.util.Stack;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class SectionManager {
    String collection_;
    Agent agent_;
    static final int HOLD = 0;
    static final int NO_HOLD = 1;
    Stack freeSectionsNonHold_ = null;
    Stack freeSectionsHold_ = null;
    int nextAvailableSectionNumber_ = 1;
    public static byte[] holdPKGNAMCBytes = null;
    public static byte[] noHoldPKGNAMCBytes = null;
    static final String packageNameWithHold__ = "SYSLH000";
    static final String packageNameWithNoHold__ = "SYSLN000";
    static final String cursorNamePrefixWithHold__ = "SQL_CURLH000C";
    static final String cursorNamePrefixWithNoHold__ = "SQL_CURLN000C";
    private Hashtable positionedUpdateCursorNameToQuerySection_ = new Hashtable();
    private Hashtable positionedUpdateCursorNameToResultSet_ = new Hashtable();
    String databaseName;
    int maxNumSections_ = 32768;

    public SectionManager(String string, Agent agent, String string2) {
        this.collection_ = string;
        this.agent_ = agent;
        this.databaseName = string2;
        this.freeSectionsNonHold_ = new Stack();
        this.freeSectionsHold_ = new Stack();
    }

    public void setPKGNAMCBytes(byte[] byArray, int n) {
        if (n == 1) {
            SectionManager cfr_ignored_0 = this.agent_.sectionManager_;
            holdPKGNAMCBytes = byArray;
        } else if (n == 2) {
            SectionManager cfr_ignored_1 = this.agent_.sectionManager_;
            noHoldPKGNAMCBytes = byArray;
        }
    }

    public Section getDynamicSection(int n) throws SqlException {
        if (n == 1) {
            return this.getSection(this.freeSectionsHold_, packageNameWithHold__, cursorNamePrefixWithHold__, n);
        }
        if (n == 2) {
            return this.getSection(this.freeSectionsNonHold_, packageNameWithNoHold__, cursorNamePrefixWithNoHold__, n);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.3"), new Integer(n));
    }

    protected Section getSection(Stack stack, String string, String string2, int n) throws SqlException {
        if (!stack.empty()) {
            return (Section)stack.pop();
        }
        if (this.nextAvailableSectionNumber_ < this.maxNumSections_ - 1) {
            String string3 = string2 + this.nextAvailableSectionNumber_;
            Section section = new Section(this.agent_, string, this.nextAvailableSectionNumber_, string3, n);
            ++this.nextAvailableSectionNumber_;
            return section;
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ200.S"), "32k");
    }

    public void freeSection(Section section, int n) {
        if (n == 1) {
            this.freeSectionsHold_.push(section);
        } else if (n == 2) {
            this.freeSectionsNonHold_.push(section);
        }
    }

    Section getPositionedUpdateSection(Section section) throws SqlException {
        Connection connection = this.agent_.connection_;
        return this.getDynamicSection(connection.holdability());
    }

    Section getPositionedUpdateSection(String string, boolean bl) throws SqlException {
        Section section = (Section)this.positionedUpdateCursorNameToQuerySection_.get(string);
        if (section != null) {
            Section section2 = this.getPositionedUpdateSection(section);
            section2.setClientCursorName(section.getClientCursorName());
            section2.serverCursorNameForPositionedUpdate_ = section.getServerCursorName();
            return section2;
        }
        return null;
    }

    void mapCursorNameToQuerySection(String string, Section section) {
        this.positionedUpdateCursorNameToQuerySection_.put(string, section);
    }

    void mapCursorNameToResultSet(String string, ResultSet resultSet) {
        this.positionedUpdateCursorNameToResultSet_.put(string, resultSet);
    }

    ResultSet getPositionedUpdateResultSet(String string) throws SqlException {
        ResultSet resultSet = (ResultSet)this.positionedUpdateCursorNameToResultSet_.get(string);
        if (resultSet == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL16.S.1"));
        }
        return resultSet.resultSetType_ == 1003 ? null : resultSet;
    }

    void removeCursorNameToResultSetMapping(String string, String string2) {
        if (string != null) {
            this.positionedUpdateCursorNameToResultSet_.remove(string);
        }
        if (string2 != null) {
            this.positionedUpdateCursorNameToResultSet_.remove(string2);
        }
    }

    void removeCursorNameToQuerySectionMapping(String string, String string2) {
        if (string != null) {
            this.positionedUpdateCursorNameToQuerySection_.remove(string);
        }
        if (string2 != null) {
            this.positionedUpdateCursorNameToQuerySection_.remove(string2);
        }
    }
}

