/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;

public class DatabaseHelper {
    private static final String PROP_INDEX_TBS = "INDEX_TBS";
    private static final String PROP_DATA_TBS = "DATA_TBS";
    private static final String PROP_SERVERNAME = "SERVERNAME";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_USERNAME = "USERNAME";
    private static final String PROP_PORT = "PORT";
    private static final String PROP_DATABASE_NAME = "DATABASE_NAME";
    private static final String PROP_HOST_NAME = "HOST_NAME";
    private static final String PROP_CONTYPE = "CONTYPE";
    private static final String PROP_TYPE = "TYPE";
    private static final String NODE_ROOT = "databaseMeta";
    private static final String NODE_ATTRIBUTES = "attributes";
    private static final String NODE_POOLING_PROPS = "poolProps";
    private static final String NODE_EXTRA_OPTIONS = "extraOptions";
    private static final String PROP_CONNECT_SQL = "connectionSQL";
    private static final String PROP_INITIAL_POOL_SIZE = "initialPoolSize";
    private static final String PROP_MAX_POOL_SIZE = "maxPoolSize";
    private static final String PROP_IS_POOLING = "isPooling";
    private static final String PROP_IS_FORCING_TO_LOWER = "isForcingLower";
    private static final String PROP_IS_FORCING_TO_UPPER = "isForcingUpper";
    private static final String PROP_IS_QUOTE_FIELDS = "isQuoteFields";
    private static final String PROP_IS_DECIMAL_SEPERATOR = "isUsingDecimalSeperator";
    private static final String ATTRIBUTE_PORT_NUMBER = "PORT_NUMBER";
    private DatabaseTypeHelper databaseTypeHelper;

    public DatabaseHelper(IDatabaseDialectService databaseDialectService) {
        this.databaseTypeHelper = new DatabaseTypeHelper(databaseDialectService.getDatabaseTypes());
    }

    public DataNode databaseConnectionToDataNode(IDatabaseConnection databaseConnection) {
        String value;
        DataNode rootNode = new DataNode(NODE_ROOT);
        if (databaseConnection.getDatabaseType() != null) {
            rootNode.setProperty(PROP_TYPE, databaseConnection.getDatabaseType().getShortName());
        }
        String port = "".equals(this.setNull(databaseConnection.getDatabasePort())) ? "0" : databaseConnection.getDatabasePort();
        rootNode.setProperty(PROP_CONTYPE, this.setNull(databaseConnection.getAccessType().getName()));
        rootNode.setProperty(PROP_HOST_NAME, this.setNull(databaseConnection.getHostname()));
        rootNode.setProperty(PROP_DATABASE_NAME, this.setNull(databaseConnection.getDatabaseName()));
        rootNode.setProperty(PROP_PORT, new Long(port).longValue());
        rootNode.setProperty(PROP_USERNAME, this.setNull(databaseConnection.getUsername()));
        rootNode.setProperty(PROP_PASSWORD, Encr.encryptPasswordIfNotUsingVariables((String)databaseConnection.getPassword()));
        rootNode.setProperty(PROP_SERVERNAME, this.setNull(databaseConnection.getInformixServername()));
        rootNode.setProperty(PROP_DATA_TBS, this.setNull(databaseConnection.getDataTablespace()));
        rootNode.setProperty(PROP_INDEX_TBS, this.setNull(databaseConnection.getIndexTablespace()));
        rootNode.setProperty(PROP_CONNECT_SQL, this.setNull(databaseConnection.getConnectSql()));
        rootNode.setProperty(PROP_INITIAL_POOL_SIZE, (long)databaseConnection.getInitialPoolSize());
        rootNode.setProperty(PROP_MAX_POOL_SIZE, (long)databaseConnection.getMaximumPoolSize());
        rootNode.setProperty(PROP_IS_POOLING, databaseConnection.isUsingConnectionPool());
        rootNode.setProperty(PROP_IS_FORCING_TO_LOWER, databaseConnection.isForcingIdentifiersToLowerCase());
        rootNode.setProperty(PROP_IS_FORCING_TO_UPPER, databaseConnection.isForcingIdentifiersToUpperCase());
        rootNode.setProperty(PROP_IS_QUOTE_FIELDS, databaseConnection.isQuoteAllFields());
        rootNode.setProperty(PROP_IS_DECIMAL_SEPERATOR, databaseConnection.isUsingDoubleDecimalAsSchemaTableSeparator());
        DataNode attrNode = rootNode.addNode(NODE_ATTRIBUTES);
        Map attributes = databaseConnection.getAttributes();
        Set keys = attributes.keySet();
        for (String key : keys) {
            value = (String)attributes.get(key);
            attrNode.setProperty(key, value);
        }
        attrNode.setProperty(ATTRIBUTE_PORT_NUMBER, new Long(port).longValue());
        attrNode = rootNode.addNode(NODE_POOLING_PROPS);
        attributes = databaseConnection.getConnectionPoolingProperties();
        keys = attributes.keySet();
        for (String key : keys) {
            value = (String)attributes.get(key);
            attrNode.setProperty(key, value);
        }
        attrNode = rootNode.addNode(NODE_EXTRA_OPTIONS);
        attributes = databaseConnection.getExtraOptions();
        for (String key : attributes.keySet()) {
            value = (String)attributes.get(key);
            attrNode.setProperty(key, value);
        }
        return rootNode;
    }

    public IDatabaseConnection databaseMetaToDatabaseConnection(DatabaseMeta databaseMeta) {
        String accessType;
        DatabaseConnection databaseConnection = new DatabaseConnection();
        databaseConnection.setDatabaseType(this.databaseTypeHelper.getDatabaseTypeByShortName(databaseMeta.getDatabaseTypeDesc()));
        databaseConnection.setName(databaseMeta.getName());
        if (databaseMeta.getObjectId() != null) {
            databaseConnection.setId(databaseMeta.getObjectId().getId());
        }
        if ((accessType = databaseMeta.getAccessTypeDesc()) != null && accessType.contains("Native")) {
            accessType = DatabaseAccessType.NATIVE.getName();
        } else if (accessType != null && accessType.equals(", ")) {
            accessType = DatabaseAccessType.JNDI.getName();
        }
        databaseConnection.setAccessType(accessType != null ? DatabaseAccessType.getAccessTypeByName((String)accessType) : null);
        databaseConnection.setHostname(databaseMeta.getHostname());
        databaseConnection.setDatabaseName(databaseMeta.getDatabaseName());
        databaseConnection.setDatabasePort(databaseMeta.getDatabasePortNumberString());
        databaseConnection.setUsername(databaseMeta.getUsername());
        databaseConnection.setPassword(databaseMeta.getPassword());
        databaseConnection.setInformixServername(databaseMeta.getServername());
        databaseConnection.setDataTablespace(databaseMeta.getDataTablespace());
        databaseConnection.setIndexTablespace(databaseMeta.getIndexTablespace());
        databaseConnection.setConnectSql(databaseMeta.getConnectSQL());
        databaseConnection.setInitialPoolSize(databaseMeta.getInitialPoolSize());
        databaseConnection.setMaximumPoolSize(databaseMeta.getMaximumPoolSize());
        databaseConnection.setUsingConnectionPool(databaseMeta.isUsingConnectionPool());
        databaseConnection.setForcingIdentifiersToLowerCase(databaseMeta.isForcingIdentifiersToLowerCase());
        databaseConnection.setForcingIdentifiersToUpperCase(databaseMeta.isForcingIdentifiersToUpperCase());
        databaseConnection.setQuoteAllFields(databaseMeta.isQuoteAllFields());
        databaseConnection.setUsingDoubleDecimalAsSchemaTableSeparator(databaseMeta.isUsingDoubleDecimalAsSchemaTableSeparator());
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : databaseMeta.getAttributes().entrySet()) {
            attributeMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        databaseConnection.setAttributes(attributeMap);
        HashMap<String, String> connectionPoolingMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : databaseMeta.getConnectionPoolingProperties().entrySet()) {
            connectionPoolingMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        databaseConnection.setConnectionPoolingProperties(connectionPoolingMap);
        databaseConnection.setExtraOptions(databaseMeta.getExtraOptions());
        return databaseConnection;
    }

    public IDatabaseConnection dataNodeToDatabaseConnection(Serializable id, String name, DataNode rootNode) {
        String attribute;
        String code;
        String accessType;
        DatabaseConnection databaseConnection = new DatabaseConnection();
        String databaseType = this.getString(rootNode, PROP_TYPE);
        databaseConnection.setDatabaseType(databaseType != null ? this.databaseTypeHelper.getDatabaseTypeByShortName(databaseType) : null);
        databaseConnection.setName(name);
        if (id != null) {
            databaseConnection.setId(id.toString());
        }
        if ((accessType = this.getString(rootNode, PROP_CONTYPE)) != null && accessType.contains("Native")) {
            accessType = DatabaseAccessType.NATIVE.getName();
        } else if (accessType != null && accessType.equals(", ")) {
            accessType = DatabaseAccessType.JNDI.getName();
        }
        databaseConnection.setAccessType(accessType != null ? DatabaseAccessType.getAccessTypeByName((String)accessType) : null);
        databaseConnection.setHostname(this.getString(rootNode, PROP_HOST_NAME));
        databaseConnection.setDatabaseName(this.getString(rootNode, PROP_DATABASE_NAME));
        databaseConnection.setDatabasePort(this.getString(rootNode, PROP_PORT));
        databaseConnection.setUsername(this.getString(rootNode, PROP_USERNAME));
        databaseConnection.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getString(rootNode, PROP_PASSWORD)));
        databaseConnection.setInformixServername(this.getString(rootNode, PROP_SERVERNAME));
        databaseConnection.setDataTablespace(this.getString(rootNode, PROP_DATA_TBS));
        databaseConnection.setIndexTablespace(this.getString(rootNode, PROP_INDEX_TBS));
        databaseConnection.setConnectSql(this.getString(rootNode, PROP_CONNECT_SQL));
        databaseConnection.setInitialPoolSize(this.getInt(rootNode, PROP_INITIAL_POOL_SIZE));
        databaseConnection.setMaximumPoolSize(this.getInt(rootNode, PROP_MAX_POOL_SIZE));
        databaseConnection.setUsingConnectionPool(this.getBoolean(rootNode, PROP_IS_POOLING));
        databaseConnection.setForcingIdentifiersToLowerCase(this.getBoolean(rootNode, PROP_IS_FORCING_TO_LOWER));
        databaseConnection.setForcingIdentifiersToUpperCase(this.getBoolean(rootNode, PROP_IS_FORCING_TO_UPPER));
        databaseConnection.setQuoteAllFields(this.getBoolean(rootNode, PROP_IS_QUOTE_FIELDS));
        databaseConnection.setUsingDoubleDecimalAsSchemaTableSeparator(this.getBoolean(rootNode, PROP_IS_DECIMAL_SEPERATOR));
        DataNode attrNode = rootNode.getNode(NODE_ATTRIBUTES);
        if (attrNode != null) {
            for (DataProperty property : attrNode.getProperties()) {
                code = property.getName();
                attribute = property.getString();
                databaseConnection.getAttributes().put(code, attribute == null || attribute.length() == 0 ? "" : attribute);
            }
        }
        if ((attrNode = rootNode.getNode(NODE_POOLING_PROPS)) != null) {
            for (DataProperty property : attrNode.getProperties()) {
                code = property.getName();
                attribute = property.getString();
                databaseConnection.getConnectionPoolingProperties().put(code, attribute == null || attribute.length() == 0 ? "" : attribute);
            }
        }
        if ((attrNode = rootNode.getNode(NODE_EXTRA_OPTIONS)) != null) {
            for (DataProperty property : attrNode.getProperties()) {
                code = property.getName();
                attribute = property.getString();
                databaseConnection.getExtraOptions().put(code, attribute == null || attribute.length() == 0 ? "" : attribute);
            }
        }
        return databaseConnection;
    }

    private String setNull(String value) {
        String response = value;
        if (value == null) {
            response = "";
        }
        return response;
    }

    private int getInt(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return (int)node.getProperty(name).getLong();
        }
        return 0;
    }

    private boolean getBoolean(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getBoolean();
        }
        return false;
    }

    private String getString(DataNode node, String name) {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getString();
        }
        return null;
    }
}

