/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.dbbased;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.IFileFilter;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISearchable;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.UUIDUtil;
import org.springframework.security.acl.basic.AclObjectIdentity;

public class RepositoryFile
implements ISearchable,
Comparable,
AclObjectIdentity,
IAclSolutionFile,
ISolutionFile {
    public static final char EXTENSION_CHAR = '.';
    private static final long serialVersionUID = -4129429077568560627L;
    private static final String EMPTY_STRING = "";
    private static final String[] SearchableColumns = new String[]{Messages.getInstance().getString("SolutionRepository.QUERY_COLUMN_NAME"), Messages.getInstance().getString("SolutionRepository.QUERY_COLUMN_PATH"), Messages.getInstance().getString("SolutionRepository.QUERY_COLUMN_PARENT")};
    private static final String SearchableTable = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile";
    private static final String SearchablePhraseNamedQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.folderSearcher";
    protected int revision;
    protected String fileId;
    protected RepositoryFile parent;
    protected String fileName;
    protected String fullPath;
    protected long lastModified;
    protected boolean directory = true;
    private byte[] data = null;
    private Set childrenFiles = new TreeSet();
    private List<IPentahoAclEntry> accessControls = new ArrayList<IPentahoAclEntry>();

    public RepositoryFile() {
    }

    public RepositoryFile(String fileName, RepositoryFile parent, byte[] data) {
        this(fileName, parent, data, System.currentTimeMillis());
    }

    public RepositoryFile(String fileName, RepositoryFile parent, byte[] data, long lastModified) {
        this();
        this.fileId = UUIDUtil.getUUIDAsString();
        this.fileName = fileName;
        if (parent != null) {
            parent.addChildFile(this);
        }
        this.setParent(parent);
        this.setData(data);
        this.setLastModified(lastModified);
        this.directory = data == null;
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryFile)) {
            return false;
        }
        RepositoryFile that = (RepositoryFile)other;
        return this.getFileId().equals(that.getFileId());
    }

    protected void resolvePath() {
        StringBuffer buffer = new StringBuffer(EMPTY_STRING);
        if (this.parent != null) {
            buffer.append(this.parent.getFullPath());
        }
        buffer.append("/");
        buffer.append(this.fileName);
        this.setFullPath(buffer.toString());
    }

    public List<IPentahoAclEntry> getAccessControls() {
        return this.accessControls;
    }

    public void setAccessControls(List<IPentahoAclEntry> acls) {
        this.accessControls = acls;
    }

    public void resetAccessControls(List<IPentahoAclEntry> acls) {
        if (this.accessControls != null) {
            this.accessControls.clear();
            this.accessControls.addAll(acls);
        }
    }

    public int getRevision() {
        return this.revision;
    }

    protected void setRevision(int revision) {
        this.revision = revision;
    }

    public String getFileId() {
        return this.fileId;
    }

    protected void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getSolution() {
        return this.getTopFolder().getFileName();
    }

    public String getSolutionPath() {
        ArrayList<String> pathList = new ArrayList<String>();
        RepositoryFile folder = this.parent;
        while (!folder.isRoot() && folder.retrieveParent() != null) {
            pathList.add(folder.getFileName());
            folder = folder.retrieveParent();
        }
        StringBuffer buffer = new StringBuffer(EMPTY_STRING);
        for (int i = pathList.size() - 1; i >= 0; --i) {
            buffer.append("/");
            buffer.append(pathList.get(i).toString());
        }
        return buffer.toString();
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
        this.resolvePath();
    }

    public String getFullPath() {
        return this.fullPath;
    }

    protected void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public void setParent(RepositoryFile parent) {
        this.parent = parent;
        this.resolvePath();
    }

    public RepositoryFile getParent() {
        return this.parent;
    }

    public ISolutionFile retrieveParent() {
        return this.parent;
    }

    protected RepositoryFile getTopFolder() {
        RepositoryFile topFolder = this.parent;
        if (topFolder == null) {
            return this;
        }
        while (!topFolder.isRoot()) {
            topFolder = (RepositoryFile)topFolder.retrieveParent();
        }
        return topFolder;
    }

    public String[] getSearchableColumns() {
        return SearchableColumns;
    }

    public String getSearchableTable() {
        return SearchableTable;
    }

    public String getPhraseSearchQueryName() {
        return SearchablePhraseNamedQuery;
    }

    protected void setDirectory(boolean directory) {
        this.directory = directory;
    }

    protected boolean getDirectory() {
        return this.directory;
    }

    public boolean isDirectory() {
        return this.getDirectory();
    }

    public Set getChildrenFiles() {
        return this.childrenFiles;
    }

    public void setChildrenFiles(Set childrenFiles) {
        this.childrenFiles = childrenFiles;
    }

    public void addChildFile(RepositoryFile file) {
        this.getChildrenFiles().add(file);
    }

    public void removeChildFile(RepositoryFile file) {
        this.getChildrenFiles().remove(file);
        file.setParent(null);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public ISolutionFile[] listFiles(IFileFilter filter) {
        Object[] objArray;
        ArrayList<Object> matchedFiles = new ArrayList<Object>();
        for (Object element : objArray = this.getChildrenFiles().toArray()) {
            if (!filter.accept((ISolutionFile)element)) continue;
            matchedFiles.add(element);
        }
        return matchedFiles.toArray(new ISolutionFile[0]);
    }

    public ISolutionFile[] listFiles() {
        Set files = this.getChildrenFiles();
        return files.toArray(new ISolutionFile[0]);
    }

    public RepositoryFile[] listRepositoryFiles() {
        RepositoryFile[] files = new RepositoryFile[this.getChildrenFiles().size()];
        Iterator iter = this.getChildrenFiles().iterator();
        int i = 0;
        while (iter.hasNext()) {
            files[i] = (RepositoryFile)iter.next();
            ++i;
        }
        return files;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof RepositoryFile) {
            RepositoryFile that = (RepositoryFile)o;
            if (this.getFullPath() == null && that.getFullPath() == null) {
                return 0;
            }
            if (this.getFullPath() == null && that.getFullPath() != null) {
                return -1;
            }
            if (this.getFullPath() != null && that.getFullPath() == null) {
                return 1;
            }
            return this.getFullPath().compareTo(((RepositoryFile)o).getFullPath());
        }
        return this.getFullPath().compareTo(o.toString());
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long modDate) {
        this.lastModified = modDate;
    }

    public boolean containsActions() {
        boolean hasActions = false;
        if (this.isDirectory()) {
            Set children = this.getChildrenFiles();
            Iterator iter = children.iterator();
            while (iter.hasNext() && !hasActions) {
                RepositoryFile file = (RepositoryFile)iter.next();
                hasActions = file.getFileName().toLowerCase().endsWith(".xaction");
            }
        }
        return hasActions;
    }

    public boolean isRoot() {
        return this.retrieveParent() == null;
    }

    public boolean hasExtension() {
        return this.fileName.lastIndexOf(46) != -1;
    }

    public String getExtension() {
        return this.hasExtension() ? this.fileName.substring(this.fileName.lastIndexOf(46)) : EMPTY_STRING;
    }

    public boolean exists() {
        return true;
    }

    public List<IPentahoAclEntry> getEffectiveAccessControls() {
        List<IPentahoAclEntry> acls = this.getAccessControls();
        if (acls.size() == 0) {
            RepositoryFile chain = this;
            while (!chain.isRoot() && acls.size() == 0) {
                chain = (RepositoryFile)chain.retrieveParent();
                acls = chain.getAccessControls();
            }
        }
        return acls;
    }
}

