/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IAclNodeHelper;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataNodeRef;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository.messages.Messages;

public class JcrAclNodeHelper
implements IAclNodeHelper {
    private static final Log logger = LogFactory.getLog(JcrAclNodeHelper.class);
    private static final String IS_ACL_NODE = "IS_ACL_NODE";
    private static final String TARGET = "TARGET";
    private final IUnifiedRepository unifiedRepository;

    public JcrAclNodeHelper(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    private boolean hasAclNode(RepositoryFile file) {
        return this.getAclNode(file) != null;
    }

    private RepositoryFile getAclNode(final RepositoryFile file) {
        try {
            return (RepositoryFile)SecurityHelper.getInstance().runAsSystem((Callable)new Callable<RepositoryFile>(){

                @Override
                public RepositoryFile call() throws Exception {
                    List referrers = JcrAclNodeHelper.this.unifiedRepository.getReferrers(file.getId());
                    int i = referrers.size();
                    while (i-- > 0) {
                        RepositoryFile referrer = (RepositoryFile)referrers.get(i);
                        NodeRepositoryFileData dataForRead = (NodeRepositoryFileData)JcrAclNodeHelper.this.unifiedRepository.getDataForRead(referrer.getId(), NodeRepositoryFileData.class);
                        if (dataForRead == null || !dataForRead.getNode().hasProperty(JcrAclNodeHelper.IS_ACL_NODE)) continue;
                        return referrer;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Error retrieving ACL Node", (Throwable)e);
            return null;
        }
    }

    public boolean canAccess(RepositoryFile repositoryFile, EnumSet<RepositoryFilePermission> permissions) {
        boolean hasAclNode = this.hasAclNode(repositoryFile);
        if (!hasAclNode) {
            return true;
        }
        RepositoryFile aclNode = this.getAclNode(repositoryFile);
        try {
            this.unifiedRepository.getFileById(aclNode.getId());
        }
        catch (Exception e) {
            logger.warn((Object)"Error checking access for file", (Throwable)e);
            return false;
        }
        return this.unifiedRepository.hasAccess(aclNode.getPath(), permissions);
    }

    public RepositoryFileAcl getAclFor(RepositoryFile repositoryFile) {
        RepositoryFileAcl acl;
        boolean hasAclNode = this.hasAclNode(repositoryFile);
        if (!hasAclNode) {
            return null;
        }
        try {
            acl = this.unifiedRepository.getAcl(this.getAclNode(repositoryFile).getId());
        }
        catch (Exception e) {
            return null;
        }
        RepositoryFileAcl.Builder aclBuilder = new RepositoryFileAcl.Builder(acl.getId(), acl.getOwner().getName(), RepositoryFileSid.Type.ROLE);
        aclBuilder.aces(acl.getAces());
        if (this.canAdminister()) {
            String adminRoleName = (String)PentahoSystem.get(String.class, (String)"singleTenantAdminAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession());
            RepositoryFileAce adminGroup = new RepositoryFileAce(new RepositoryFileSid(adminRoleName, RepositoryFileSid.Type.ROLE), RepositoryFilePermission.ALL, new RepositoryFilePermission[0]);
            aclBuilder.ace(adminGroup);
        }
        return aclBuilder.build();
    }

    public void setAclFor(final RepositoryFile fileToAddAclFor, final RepositoryFileAcl acl) {
        try {
            SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RepositoryFile aclNode = JcrAclNodeHelper.this.getAclNode(fileToAddAclFor);
                    if (acl == null) {
                        if (aclNode != null) {
                            JcrAclNodeHelper.this.unifiedRepository.deleteFile(aclNode.getId(), true, Messages.getInstance().getString("AclNodeHelper.WARN_0001_REMOVE_ACL_NODE", new Object[]{aclNode.getPath()}));
                        }
                    } else {
                        if (aclNode == null) {
                            aclNode = JcrAclNodeHelper.this.createAclNode(fileToAddAclFor);
                        }
                        RepositoryFileAcl existing = JcrAclNodeHelper.this.unifiedRepository.getAcl(aclNode.getId());
                        RepositoryFileAcl updated = new RepositoryFileAcl.Builder(existing).aces(acl.getAces()).build();
                        JcrAclNodeHelper.this.unifiedRepository.updateAcl(updated);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)("Error setting ACL on node: " + fileToAddAclFor.getPath()), (Throwable)e);
        }
    }

    private RepositoryFile createAclNode(RepositoryFile fileToAddAclFor) {
        DataNode dataNode = new DataNode("acl node");
        DataNodeRef dataNodeRef = new DataNodeRef(fileToAddAclFor.getId());
        dataNode.setProperty(TARGET, dataNodeRef);
        dataNode.setProperty(IS_ACL_NODE, true);
        NodeRepositoryFileData nodeRepositoryFileData = new NodeRepositoryFileData(dataNode);
        return this.unifiedRepository.createFile(this.unifiedRepository.getFile("/").getId(), new RepositoryFile.Builder(UUID.randomUUID().toString()).aclNode(true).build(), (IRepositoryFileData)nodeRepositoryFileData, "");
    }

    public void removeAclFor(RepositoryFile file) {
        this.setAclFor(file, null);
    }

    private boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

