/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.IRepositoryAccessVoterManager;
import org.pentaho.platform.api.repository2.unified.IRepositoryDefaultAclHandler;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.repository2.messages.Messages;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.IDeleteHelper;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.ITransformer;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.springframework.util.Assert;

public class JcrRepositoryFileDaoInst {
    private List<ITransformer<IRepositoryFileData>> transformers;
    private ILockHelper lockHelper;
    private IDeleteHelper deleteHelper;
    private IPathConversionHelper pathConversionHelper;
    private IRepositoryFileAclDao aclDao;
    private IRepositoryDefaultAclHandler defaultAclHandler;
    private IRepositoryAccessVoterManager accessVoterManager;
    private String repositoryAdminUsername;

    public JcrRepositoryFileDaoInst(List<ITransformer<IRepositoryFileData>> transformers, ILockHelper lockHelper, IDeleteHelper deleteHelper, IPathConversionHelper pathConversionHelper, IRepositoryFileAclDao aclDao, IRepositoryDefaultAclHandler defaultAclHandler, String repositoryAdminUsername) {
        Assert.notNull(transformers);
        this.transformers = transformers;
        this.lockHelper = lockHelper;
        this.deleteHelper = deleteHelper;
        this.pathConversionHelper = pathConversionHelper;
        this.aclDao = aclDao;
        this.defaultAclHandler = defaultAclHandler;
        this.repositoryAdminUsername = repositoryAdminUsername;
    }

    public JcrRepositoryFileDaoInst(List<ITransformer<IRepositoryFileData>> transformers, ILockHelper lockHelper, IDeleteHelper deleteHelper, IPathConversionHelper pathConversionHelper, IRepositoryFileAclDao aclDao, IRepositoryDefaultAclHandler defaultAclHandler, IRepositoryAccessVoterManager accessVoterManager, String repositoryAdminUsername) {
        this(transformers, lockHelper, deleteHelper, pathConversionHelper, aclDao, defaultAclHandler, repositoryAdminUsername);
        this.accessVoterManager = accessVoterManager;
    }

    public void setDefaultAclHandler(IRepositoryDefaultAclHandler defaultAclHandler) {
        this.defaultAclHandler = defaultAclHandler;
    }

    public VersionSummary getVersionSummary(Session session, Serializable fileId, Serializable versionId) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return JcrRepositoryFileUtils.getVersionSummary(session, pentahoJcrConstants, fileId, versionId);
    }

    public RepositoryFile internalCreateFolder(Session session, Serializable parentFolderId, RepositoryFile folder, RepositoryFileAcl acl, String versionMessage) throws RepositoryException {
        if (!this.hasAccess(session, parentFolderId, RepositoryFilePermission.WRITE)) {
            return null;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
        Node folderNode = JcrRepositoryFileUtils.createFolderNode(session, pentahoJcrConstants, parentFolderId, folder);
        String path = JcrRepositoryFileUtils.getAbsolutePath(session, pentahoJcrConstants, folderNode);
        RepositoryFile tmpFolder = new RepositoryFile.Builder(folder).path(path).build();
        JcrRepositoryFileAclUtils.createAcl(session, pentahoJcrConstants, (Serializable)((Object)folderNode.getIdentifier()), acl == null ? this.defaultAclHandler.createDefaultAcl(tmpFolder) : acl);
        session.save();
        if (folder.isVersioned()) {
            JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, folderNode, versionMessage);
        }
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, Messages.getInstance().getString("JcrRepositoryFileDao.USER_0001_VER_COMMENT_ADD_FOLDER", new Object[]{folder.getName(), parentFolderId == null ? "root" : parentFolderId.toString()}));
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, folderNode);
    }

    public RepositoryFile internalCreateFile(Session session, Serializable parentFolderId, RepositoryFile file, IRepositoryFileData content, RepositoryFileAcl acl, String versionMessage) throws RepositoryException {
        if (!this.hasAccess(session, parentFolderId, RepositoryFilePermission.WRITE)) {
            return null;
        }
        DataNode emptyDataNode = new DataNode(file.getName());
        emptyDataNode.setProperty(" ", "content");
        NodeRepositoryFileData emptyContent = new NodeRepositoryFileData(emptyDataNode);
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
        Node fileNode = JcrRepositoryFileUtils.createFileNode(session, pentahoJcrConstants, parentFolderId, file, (IRepositoryFileData)(content == null ? emptyContent : content), this.findTransformerForWrite(content == null ? emptyContent.getClass() : content.getClass()));
        String path = JcrRepositoryFileUtils.getAbsolutePath(session, pentahoJcrConstants, fileNode);
        RepositoryFile tmpFile = new RepositoryFile.Builder(file).path(path).build();
        this.aclDao.createAcl((Serializable)((Object)fileNode.getIdentifier()), acl == null ? this.defaultAclHandler.createDefaultAcl(tmpFile) : acl);
        session.save();
        if (file.isVersioned()) {
            JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, fileNode, versionMessage, file.getCreatedDate(), false);
        }
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, Messages.getInstance().getString("JcrRepositoryFileDao.USER_0002_VER_COMMENT_ADD_FILE", new Object[]{file.getName(), parentFolderId == null ? "root" : parentFolderId.toString()}));
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, fileNode);
    }

    public RepositoryFile internalUpdateFile(Session session, RepositoryFile file, IRepositoryFileData content, String versionMessage) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        if (!this.hasAccess(file, RepositoryFilePermission.WRITE)) {
            return null;
        }
        this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, file.getId());
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, file.getId());
        JcrRepositoryFileUtils.updateFileNode(session, pentahoJcrConstants, file, content, this.findTransformerForWrite(content.getClass()));
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, file.getId(), versionMessage, new Date(), true);
        this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, file.getId());
        return JcrRepositoryFileUtils.nodeIdToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, file.getId());
    }

    public RepositoryFile internalUpdateFolder(Session session, RepositoryFile folder, String versionMessage) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, folder.getId());
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, folder.getId());
        JcrRepositoryFileUtils.updateFolderNode(session, pentahoJcrConstants, folder);
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, folder.getId(), versionMessage);
        this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, folder.getId());
        return JcrRepositoryFileUtils.nodeIdToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, folder.getId());
    }

    public void undeleteFile(Session session, Serializable fileId, String versionMessage) throws RepositoryException, IOException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String absOrigParentFolderPath = this.deleteHelper.getOriginalParentFolderPath(session, pentahoJcrConstants, fileId);
        Object origParentFolderId = null;
        if (!this.hasAccess(session, fileId, RepositoryFilePermission.WRITE)) {
            return;
        }
        if (session.itemExists(JcrStringHelper.pathEncode(absOrigParentFolderPath))) {
            origParentFolderId = ((Node)session.getItem(JcrStringHelper.pathEncode(absOrigParentFolderPath))).getIdentifier();
        } else {
            String[] segments = this.pathConversionHelper.absToRel(absOrigParentFolderPath).split("/");
            RepositoryFile lastParentFolder = this.internalGetFile(session, ServerRepositoryPaths.getTenantRootFolderPath(), false, null);
            for (String segment : segments) {
                if (!org.springframework.util.StringUtils.hasLength((String)segment)) continue;
                RepositoryFile tmp = this.internalGetFile(session, this.pathConversionHelper.relToAbs((lastParentFolder.getPath().equals("/") ? "" : lastParentFolder.getPath()) + "/" + segment), false, null);
                lastParentFolder = tmp == null ? this.internalCreateFolder(session, lastParentFolder.getId(), new RepositoryFile.Builder(segment).folder(true).build(), this.defaultAclHandler.createDefaultAcl(lastParentFolder), null) : tmp;
            }
            origParentFolderId = lastParentFolder.getId();
        }
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, (Serializable)origParentFolderId);
        this.deleteHelper.undeleteFile(session, pentahoJcrConstants, fileId);
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, (Serializable)origParentFolderId, versionMessage);
    }

    public void deleteFile(Session session, Serializable fileId, String versionMessage) throws RepositoryException {
        if (!this.hasAccess(session, fileId, RepositoryFilePermission.DELETE)) {
            return;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Serializable parentFolderId = JcrRepositoryFileUtils.getParentId(session, fileId);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
        this.deleteHelper.deleteFile(session, pentahoJcrConstants, fileId);
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, versionMessage);
    }

    public void deleteFileAtVersion(Session session, Serializable fileId, Serializable versionId) throws RepositoryException {
        if (!this.hasAccess(session, fileId, RepositoryFilePermission.DELETE)) {
            return;
        }
        Node fileToDeleteNode = session.getNodeByIdentifier(fileId.toString());
        session.getWorkspace().getVersionManager().getVersionHistory(fileToDeleteNode.getPath()).removeVersion(versionId.toString());
        session.save();
    }

    public List<RepositoryFile> getDeletedFiles(Session session, String origParentFolderPath, String filter) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return this.deleteHelper.getDeletedFiles(session, pentahoJcrConstants, origParentFolderPath, filter);
    }

    public void permanentlyDeleteFile(Session session, Serializable fileId, String versionMessage) throws RepositoryException {
        if (!this.hasAccess(session, fileId, RepositoryFilePermission.DELETE)) {
            return;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        this.deleteHelper.permanentlyDeleteFile(session, pentahoJcrConstants, fileId);
        session.save();
    }

    public List<RepositoryFile> getChildren(Session session, RepositoryRequest repositoryRequest) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return JcrRepositoryFileUtils.getChildren(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, repositoryRequest);
    }

    public List<RepositoryFile> getChildren(Session session, Serializable folderId, String filter, Boolean showHiddenFiles) throws RepositoryException, IOException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return JcrRepositoryFileUtils.getChildren(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, folderId, filter, showHiddenFiles);
    }

    public <T extends IRepositoryFileData> IRepositoryFileData getData(Session session, Serializable fileId, Serializable versionId, Class<T> contentClass) throws RepositoryException {
        if (!this.hasAccess(session, fileId, RepositoryFilePermission.READ)) {
            return null;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return JcrRepositoryFileUtils.getContent(session, pentahoJcrConstants, fileId, versionId, this.findTransformerForRead(JcrRepositoryFileUtils.getFileContentType(session, pentahoJcrConstants, fileId, versionId), contentClass));
    }

    public List<RepositoryFile> getDeletedFiles(Session session) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return this.deleteHelper.getDeletedFiles(session, pentahoJcrConstants);
    }

    protected ITransformer<IRepositoryFileData> findTransformerForRead(String contentType, Class<? extends IRepositoryFileData> clazz) {
        for (ITransformer<IRepositoryFileData> transformer : this.transformers) {
            if (!transformer.canRead(contentType, clazz)) continue;
            return transformer;
        }
        throw new IllegalArgumentException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0001_NO_TRANSFORMER"));
    }

    protected ITransformer<IRepositoryFileData> findTransformerForWrite(Class<? extends IRepositoryFileData> clazz) {
        for (ITransformer<IRepositoryFileData> transformer : this.transformers) {
            if (!transformer.canWrite(clazz)) continue;
            return transformer;
        }
        throw new IllegalArgumentException(Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0001_NO_TRANSFORMER"));
    }

    public RepositoryFile checkAndGetFileById(Session session, Serializable fileId, boolean loadMaps, IPentahoLocale locale) throws RepositoryException {
        RepositoryFile file = this.internalGetFileById(session, fileId, loadMaps, locale);
        if (file != null && !this.hasAccess(file, RepositoryFilePermission.READ)) {
            return null;
        }
        return file;
    }

    private RepositoryFile internalGetFileById(Session session, Serializable fileId, boolean loadMaps, IPentahoLocale locale) throws RepositoryException {
        Assert.notNull((Object)fileId);
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        RepositoryFile file = fileNode != null ? JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, fileNode, loadMaps, locale) : null;
        return file;
    }

    public RepositoryFile getFileByRelPath(Session session, String relPath, boolean loadMaps, IPentahoLocale locale) throws RepositoryException {
        String absPath = this.pathConversionHelper.relToAbs(relPath);
        return this.internalGetFile(session, absPath, loadMaps, locale);
    }

    public RepositoryFile internalGetFile(Session session, String absPath, boolean loadMaps, IPentahoLocale locale) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        try {
            Item fileNode = session.getItem(JcrStringHelper.pathEncode(absPath));
            if (fileNode == null) {
                return null;
            }
            Assert.isTrue((boolean)fileNode.isNode());
            RepositoryFile file = JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, (Node)fileNode, loadMaps, locale);
            if (file == null || !this.hasAccess(file, RepositoryFilePermission.READ)) {
                return null;
            }
            return file;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private boolean isUser() {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        String name = pentahoSession.getName();
        return name != null && !name.equals(this.repositoryAdminUsername);
    }

    private boolean hasAccess(Session session, Serializable fileId, RepositoryFilePermission ... permissions) throws RepositoryException {
        if (!this.isUser()) {
            return true;
        }
        return this.hasUserAccess(this.internalGetFileById(session, fileId, false, null), permissions);
    }

    private boolean hasAccess(RepositoryFile file, RepositoryFilePermission ... permissions) {
        if (!this.isUser()) {
            return true;
        }
        return this.hasUserAccess(file, permissions);
    }

    private boolean hasUserAccess(RepositoryFile file, RepositoryFilePermission ... permissions) {
        if (ArrayUtils.isEmpty((Object[])permissions)) {
            return false;
        }
        RepositoryFileAcl acl = this.aclDao.getAcl(file.getId());
        for (RepositoryFilePermission permission : permissions) {
            if (this.accessVoterManager.hasAccess(file, permission, acl, PentahoSessionHolder.getSession())) continue;
            return false;
        }
        return true;
    }

    public void internalCopyOrMove(Session session, RepositoryFile file, String destRelPath, String versionMessage, boolean copy) throws RepositoryException, IOException {
        String absPathToDestParentFolder;
        if (!this.hasAccess(file, RepositoryFilePermission.WRITE)) {
            return;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String destAbsPath = this.pathConversionHelper.relToAbs(destRelPath);
        String cleanDestAbsPath = destAbsPath;
        if (cleanDestAbsPath.endsWith("/")) {
            cleanDestAbsPath.substring(0, cleanDestAbsPath.length() - 1);
        }
        Node srcFileNode = session.getNodeByIdentifier(file.getId().toString());
        Serializable srcParentFolderId = JcrRepositoryFileUtils.getParentId(session, file.getId());
        boolean appendFileName = false;
        boolean destExists = true;
        Node destFileNode = null;
        Node destParentFolderNode = null;
        try {
            destFileNode = (Node)session.getItem(JcrStringHelper.pathEncode(cleanDestAbsPath));
        }
        catch (PathNotFoundException e) {
            destExists = false;
        }
        if (destExists) {
            Assert.isTrue((boolean)JcrRepositoryFileUtils.isSupportedNodeType(pentahoJcrConstants, destFileNode));
            Assert.isTrue((!JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, srcFileNode) || !JcrRepositoryFileUtils.isPentahoFile(pentahoJcrConstants, destFileNode) ? 1 : 0) != 0, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0002_CANNOT_OVERWRITE_FILE_WITH_FOLDER"));
            if (JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, destFileNode)) {
                appendFileName = true;
                destParentFolderNode = destFileNode;
            } else {
                int lastSlashIndex = cleanDestAbsPath.lastIndexOf("/");
                Assert.isTrue((lastSlashIndex > 1 ? 1 : 0) != 0, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0003_ILLEGAL_DEST_PATH"));
                absPathToDestParentFolder = cleanDestAbsPath.substring(0, lastSlashIndex);
                destParentFolderNode = (Node)session.getItem(JcrStringHelper.pathEncode(absPathToDestParentFolder));
            }
        } else {
            int lastSlashIndex = cleanDestAbsPath.lastIndexOf("/");
            Assert.isTrue((lastSlashIndex > 1 ? 1 : 0) != 0, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0003_ILLEGAL_DEST_PATH"));
            absPathToDestParentFolder = cleanDestAbsPath.substring(0, lastSlashIndex);
            try {
                destParentFolderNode = (Node)session.getItem(JcrStringHelper.pathEncode(absPathToDestParentFolder));
            }
            catch (PathNotFoundException e1) {
                Assert.isTrue((boolean)false, (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0004_PARENT_MUST_EXIST"));
            }
            Assert.isTrue((boolean)JcrRepositoryFileUtils.isPentahoFolder(pentahoJcrConstants, destParentFolderNode), (String)Messages.getInstance().getString("JcrRepositoryFileDao.ERROR_0005_PARENT_MUST_BE_FOLDER"));
        }
        if (!copy) {
            JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, srcParentFolderId);
        }
        JcrRepositoryFileUtils.checkoutNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, destParentFolderNode);
        String finalEncodedSrcAbsPath = srcFileNode.getPath();
        String finalDestAbsPath = appendFileName && !file.isFolder() ? cleanDestAbsPath + "/" + srcFileNode.getName() : cleanDestAbsPath;
        try {
            if (copy) {
                session.getWorkspace().copy(finalEncodedSrcAbsPath, JcrStringHelper.pathEncode(finalDestAbsPath));
            } else {
                session.getWorkspace().move(finalEncodedSrcAbsPath, JcrStringHelper.pathEncode(finalDestAbsPath));
            }
        }
        catch (ItemExistsException iae) {
            throw new UnifiedRepositoryException((file.isFolder() ? "Folder " : "File ") + "with path [" + cleanDestAbsPath + "] already exists in the repository");
        }
        JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, destParentFolderNode, versionMessage);
        if (!copy && !destParentFolderNode.getIdentifier().equals(srcParentFolderId.toString())) {
            JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, srcParentFolderId, versionMessage);
        }
        session.save();
    }

    protected RepositoryFile getReferrerFile(Session session, PentahoJcrConstants pentahoJcrConstants, Property referrerProperty) throws RepositoryException {
        Node currentNode = referrerProperty.getParent();
        while (!currentNode.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOHIERARCHYNODE())) {
            currentNode = currentNode.getParent();
        }
        if (currentNode.isNodeType(pentahoJcrConstants.getPHO_NT_PENTAHOFOLDER())) {
            return null;
        }
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, currentNode);
    }

    public List<RepositoryFile> getReferrers(Session session, Serializable fileId) throws ItemNotFoundException, RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Assert.notNull((Object)fileNode);
        HashSet<RepositoryFile> referrers = new HashSet<RepositoryFile>();
        PropertyIterator refIter = fileNode.getReferences();
        if (refIter.hasNext()) {
            while (refIter.hasNext()) {
                RepositoryFile referrer = this.getReferrerFile(session, pentahoJcrConstants, refIter.nextProperty());
                if (referrer == null) continue;
                referrers.add(referrer);
            }
        }
        session.save();
        return new ArrayList<RepositoryFile>(referrers);
    }

    public RepositoryFileTree getTree(Session session, RepositoryRequest repositoryRequest) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String absPath = this.pathConversionHelper.relToAbs(repositoryRequest.getPath());
        return JcrRepositoryFileUtils.getTree(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, absPath, repositoryRequest, this.accessVoterManager);
    }

    public boolean canUnlockFile(Session session, Serializable fileId) throws ItemNotFoundException, RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        Lock lock = session.getWorkspace().getLockManager().getLock(fileNode.getPath());
        return this.lockHelper.canUnlock(session, pentahoJcrConstants, lock);
    }

    public void restoreFileAtVersion(Session session, Serializable fileId, Serializable versionId, String versionMessage) throws ItemNotFoundException, RepositoryException {
        Node fileNode = session.getNodeByIdentifier(fileId.toString());
        session.getWorkspace().getVersionManager().restore(fileNode.getPath(), versionId.toString(), true);
    }

    public List<Locale> getAvailableLocalesForFile(RepositoryFile repositoryFile) {
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        if (repositoryFile != null && repositoryFile.getLocalePropertiesMap() != null) {
            for (String localeName : repositoryFile.getLocalePropertiesMap().keySet()) {
                String[] localePieces = localeName.split("_");
                String language = localePieces[0];
                String country = localePieces.length > 1 ? localePieces[1] : "";
                String variant = localePieces.length > 2 ? localePieces[2] : "";
                Locale locale = new Locale(language, country, variant);
                localeList.add(locale);
            }
        }
        return localeList;
    }

    public Properties getLocalePropertiesForFile(RepositoryFile repositoryFile, String locale) {
        if (StringUtils.isBlank((String)locale)) {
            locale = "default";
        }
        if (repositoryFile != null && repositoryFile.getLocalePropertiesMap() != null) {
            Properties properties = (Properties)repositoryFile.getLocalePropertiesMap().get(locale);
            return properties;
        }
        return null;
    }

    public void setLocalePropertiesForFile(Session session, RepositoryFile repositoryFile, String locale, Properties properties) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String versionMessage = Messages.getInstance().getString("JcrRepositoryFileDao.LOCALE_0001_UPDATE_PROPERTIES", new Object[]{repositoryFile.getId()});
        this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
        JcrRepositoryFileUtils.updateFileLocaleProperties(session, repositoryFile.getId(), locale, properties);
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId(), versionMessage);
        this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
    }

    public void deleteLocalePropertiesForFile(Session session, RepositoryFile repositoryFile, String locale) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String versionMessage = Messages.getInstance().getString("JcrRepositoryFileDao.LOCALE_0002_DELETE_PROPERTIES", new Object[]{repositoryFile.getId()});
        this.lockHelper.addLockTokenToSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
        JcrRepositoryFileUtils.deleteFileLocaleProperties(session, repositoryFile.getId(), locale);
        session.save();
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, repositoryFile.getId(), versionMessage);
        this.lockHelper.removeLockTokenFromSessionIfNecessary(session, pentahoJcrConstants, repositoryFile.getId());
    }

    public void lockFile(Session session, Serializable fileId, String message) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        this.lockHelper.lockFile(session, pentahoJcrConstants, fileId, message);
    }

    public void unlockFile(Session session, Serializable fileId) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        this.lockHelper.unlockFile(session, pentahoJcrConstants, fileId);
    }

    public List<VersionSummary> getVersionSummaries(Session session, Serializable fileId) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return JcrRepositoryFileUtils.getVersionSummaries(session, pentahoJcrConstants, fileId, true);
    }

    public RepositoryFile getFile(Session session, Serializable fileId, Serializable versionId) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        return JcrRepositoryFileUtils.getFileAtVersion(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, fileId, versionId);
    }
}

