/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices.jaxws;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.annotation.XmlMimeType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;

public class SimpleRepositoryFileDataDto {
    @XmlMimeType(value="application/octet-stream")
    DataHandler dataHandler;
    String encoding;
    String mimeType;

    public static SimpleRepositoryFileDataDto convert(SimpleRepositoryFileData simpleData) {
        FileOutputStream fout = null;
        boolean foutClosed = false;
        try {
            SimpleRepositoryFileDataDto simpleJaxWsData = new SimpleRepositoryFileDataDto();
            File tmpFile = File.createTempFile("pentaho-ws", null);
            tmpFile.deleteOnExit();
            fout = FileUtils.openOutputStream((File)tmpFile);
            IOUtils.copy((InputStream)simpleData.getStream(), (OutputStream)fout);
            fout.close();
            foutClosed = true;
            simpleJaxWsData.dataHandler = new DataHandler((DataSource)new FileDataSource(tmpFile));
            simpleJaxWsData.encoding = simpleData.getEncoding();
            simpleJaxWsData.mimeType = simpleData.getMimeType();
            SimpleRepositoryFileDataDto simpleRepositoryFileDataDto = simpleJaxWsData;
            return simpleRepositoryFileDataDto;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fout != null && !foutClosed) {
                    fout.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static SimpleRepositoryFileData convert(SimpleRepositoryFileDataDto simpleJaxWsData) {
        FileOutputStream fout = null;
        InputStream in = null;
        DataHandler dh = null;
        boolean foutClosed = false;
        try {
            File tmpFile = File.createTempFile("pentaho", null);
            tmpFile.deleteOnExit();
            fout = FileUtils.openOutputStream((File)tmpFile);
            dh = simpleJaxWsData.dataHandler;
            in = dh.getInputStream();
            IOUtils.copy((InputStream)in, (OutputStream)fout);
            fout.close();
            foutClosed = true;
            BufferedInputStream fin = new BufferedInputStream(FileUtils.openInputStream((File)tmpFile));
            SimpleRepositoryFileData simpleRepositoryFileData = new SimpleRepositoryFileData((InputStream)fin, simpleJaxWsData.encoding, simpleJaxWsData.mimeType);
            return simpleRepositoryFileData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fout != null && !foutClosed) {
                    fout.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        return "SimpleRepositoryFileDataDto [dataHandler=" + this.dataHandler + ", encoding=" + this.encoding + ", mimeType=" + this.mimeType + "]";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

